/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.NullExpression;
import com.mysema.query.types.Ops;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.expr.BooleanOperation;
import com.mysema.query.types.expr.DateExpression;
import com.mysema.query.types.expr.DateOperation;
import com.mysema.query.types.expr.DateTimeExpression;
import com.mysema.query.types.expr.DateTimeOperation;
import com.mysema.query.types.expr.NumberExpression;
import com.mysema.query.types.expr.NumberOperation;
import com.mysema.query.types.expr.SimpleExpression;
import com.mysema.query.types.expr.SimpleOperation;
import com.mysema.query.types.expr.StringExpression;
import com.mysema.query.types.expr.StringOperation;
import com.mysema.query.types.expr.TimeExpression;
import com.mysema.query.types.expr.TimeOperation;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class CaseBuilder {
    public Initial when(BooleanExpression b) {
        return new Initial(b);
    }

    public static class Initial {
        private final BooleanExpression when;

        public Initial(BooleanExpression b) {
            this.when = b;
        }

        public <A> Cases<A, SimpleExpression<A>> then(Expression<A> expr) {
            return new Cases<A, SimpleExpression<A>>(expr.getType()){

                @Override
                protected SimpleExpression<A> createResult(Class<A> type, Expression<A> last) {
                    return SimpleOperation.create(type, Ops.CASE, last);
                }
            }.addCase(this.when, expr);
        }

        public <A> Cases<A, SimpleExpression<A>> then(A constant) {
            return this.then((A)((Object)ConstantImpl.create(constant)));
        }

        public Cases<Boolean, BooleanExpression> then(BooleanExpression expr) {
            return this.thenBoolean(expr);
        }

        private Cases<Boolean, BooleanExpression> thenBoolean(Expression<Boolean> expr) {
            return new Cases<Boolean, BooleanExpression>(Boolean.class){

                @Override
                protected BooleanExpression createResult(Class<Boolean> type, Expression<Boolean> last) {
                    return BooleanOperation.create(Ops.CASE, last);
                }
            }.addCase(this.when, expr);
        }

        public Cases<Boolean, BooleanExpression> then(boolean b) {
            return this.thenBoolean(ConstantImpl.create(b));
        }

        public <T extends Comparable> Cases<T, DateExpression<T>> then(DateExpression<T> expr) {
            return this.thenDate(expr);
        }

        private <T extends Comparable> Cases<T, DateExpression<T>> thenDate(Expression<T> expr) {
            return new Cases<T, DateExpression<T>>(expr.getType()){

                @Override
                protected DateExpression<T> createResult(Class<T> type, Expression<T> last) {
                    return DateOperation.create(type, Ops.CASE, last);
                }
            }.addCase(this.when, expr);
        }

        public Cases<Date, DateExpression<Date>> thenDate(Date date) {
            return this.thenDate(ConstantImpl.create(date));
        }

        public <T extends Comparable> Cases<T, DateTimeExpression<T>> then(DateTimeExpression<T> expr) {
            return this.thenDateTime(expr);
        }

        private <T extends Comparable> Cases<T, DateTimeExpression<T>> thenDateTime(Expression<T> expr) {
            return new Cases<T, DateTimeExpression<T>>(expr.getType()){

                @Override
                protected DateTimeExpression<T> createResult(Class<T> type, Expression<T> last) {
                    return DateTimeOperation.create(type, Ops.CASE, last);
                }
            }.addCase(this.when, expr);
        }

        public Cases<Timestamp, DateTimeExpression<Timestamp>> thenDateTime(Timestamp ts) {
            return this.thenDateTime(ConstantImpl.create(ts));
        }

        public Cases<java.util.Date, DateTimeExpression<java.util.Date>> thenDateTime(java.util.Date date) {
            return this.thenDateTime(ConstantImpl.create(date));
        }

        public <A extends Number> Cases<A, NumberExpression<A>> then(NumberExpression<A> expr) {
            return this.thenNumber(expr);
        }

        private <A extends Number> Cases<A, NumberExpression<A>> thenNumber(Expression<A> expr) {
            return new Cases<A, NumberExpression<A>>(expr.getType()){

                @Override
                protected NumberExpression<A> createResult(Class<A> type, Expression<A> last) {
                    return NumberOperation.create(type, Ops.CASE, last);
                }
            }.addCase(this.when, expr);
        }

        public <A extends Number> Cases<A, NumberExpression<A>> then(A num) {
            return this.thenNumber(ConstantImpl.create(num));
        }

        public Cases<String, StringExpression> then(StringExpression expr) {
            return this.thenString(expr);
        }

        private Cases<String, StringExpression> thenString(Expression<String> expr) {
            return new Cases<String, StringExpression>(String.class){

                @Override
                protected StringExpression createResult(Class<String> type, Expression<String> last) {
                    return StringOperation.create(Ops.CASE, last);
                }
            }.addCase(this.when, expr);
        }

        public Cases<String, StringExpression> then(String str) {
            return this.thenString(ConstantImpl.create(str));
        }

        public <T extends Comparable> Cases<T, TimeExpression<T>> then(TimeExpression<T> expr) {
            return this.thenTime(expr);
        }

        private <T extends Comparable> Cases<T, TimeExpression<T>> thenTime(Expression<T> expr) {
            return new Cases<T, TimeExpression<T>>(expr.getType()){

                @Override
                protected TimeExpression<T> createResult(Class<T> type, Expression<T> last) {
                    return TimeOperation.create(type, Ops.CASE, last);
                }
            }.addCase(this.when, expr);
        }

        public Cases<Time, TimeExpression<Time>> then(Time time) {
            return this.thenTime(ConstantImpl.create(time));
        }
    }

    public static class CaseWhen<A, Q extends Expression<A>> {
        private final BooleanExpression b;
        private final Cases<A, Q> cases;

        public CaseWhen(Cases<A, Q> cases, BooleanExpression b) {
            this.cases = cases;
            this.b = b;
        }

        public Cases<A, Q> then(A constant) {
            return this.then((Expression<A>)ConstantImpl.create(constant));
        }

        public Cases<A, Q> then(Expression<A> expr) {
            return this.cases.addCase(this.b, expr);
        }
    }

    public static abstract class Cases<A, Q extends Expression<A>> {
        private final List<CaseElement<A>> cases = new ArrayList<CaseElement<A>>();
        private final Class<A> type;

        public Cases(Class<A> type) {
            this.type = type;
        }

        Cases<A, Q> addCase(BooleanExpression condition, Expression<A> expr) {
            this.cases.add(0, new CaseElement<A>(condition, expr));
            return this;
        }

        protected abstract Q createResult(Class<A> var1, Expression<A> var2);

        public Q otherwise(A constant) {
            if (constant != null) {
                return this.otherwise((Expression<A>)ConstantImpl.create(constant));
            }
            return this.otherwise((Expression<A>)NullExpression.DEFAULT);
        }

        public Q otherwise(Expression<A> expr) {
            if (expr == null) {
                expr = NullExpression.DEFAULT;
            }
            this.cases.add(0, new CaseElement<A>(null, expr));
            SimpleExpression<Object> last = null;
            for (CaseElement<A> element : this.cases) {
                if (last == null) {
                    last = SimpleOperation.create(this.type, Ops.CASE_ELSE, element.getTarget());
                    continue;
                }
                last = SimpleOperation.create(this.type, Ops.CASE_WHEN, element.getCondition(), element.getTarget(), last);
            }
            return this.createResult(this.type, last);
        }

        public CaseWhen<A, Q> when(BooleanExpression b) {
            return new CaseWhen(this, b);
        }
    }

    private static class CaseElement<A> {
        @Nullable
        private final BooleanExpression condition;
        private final Expression<A> target;

        public CaseElement(@Nullable BooleanExpression condition, Expression<A> target) {
            this.condition = condition;
            this.target = target;
        }

        public BooleanExpression getCondition() {
            return this.condition;
        }

        public Expression<A> getTarget() {
            return this.target;
        }
    }
}

