/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.google.common.collect.ImmutableList;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionBase;
import com.mysema.query.types.Operation;
import com.mysema.query.types.Operator;
import com.mysema.query.types.Visitor;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class OperationImpl<T>
extends ExpressionBase<T>
implements Operation<T> {
    private static final long serialVersionUID = 4796432056083507588L;
    private final ImmutableList<Expression<?>> args;
    private final Operator<? super T> operator;

    public static <RT> Operation<RT> create(Class<? extends RT> type, Operator<? super RT> operator, Expression<?> one) {
        return new OperationImpl<RT>(type, operator, ImmutableList.of(one));
    }

    public static <RT> Operation<RT> create(Class<? extends RT> type, Operator<? super RT> operator, Expression<?> one, Expression<?> two) {
        return new OperationImpl<RT>(type, operator, ImmutableList.of(one, two));
    }

    protected OperationImpl(Class<? extends T> type, Operator<? super T> operator, Expression<?> ... args) {
        this(type, operator, ImmutableList.copyOf((Object[])args));
    }

    public OperationImpl(Class<? extends T> type, Operator<? super T> operator, ImmutableList<Expression<?>> args) {
        super(type);
        this.operator = operator;
        this.args = args;
    }

    @Override
    public final Expression<?> getArg(int i) {
        return (Expression)this.args.get(i);
    }

    @Override
    public final List<Expression<?>> getArgs() {
        return this.args;
    }

    @Override
    public final Operator<? super T> getOperator() {
        return this.operator;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Operation) {
            Operation op = (Operation)o;
            return op.getOperator() == this.operator && op.getArgs().equals(this.args) && op.getType().equals(this.getType());
        }
        return false;
    }

    @Override
    public final <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this, context);
    }
}

