/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.path;

import com.mysema.query.types.Expression;
import com.mysema.query.types.ParametrizedPathImpl;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.PathMetadata;
import com.mysema.query.types.PathMetadataFactory;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.ListExpression;
import com.mysema.query.types.expr.SimpleExpression;
import com.mysema.query.types.path.CollectionPathBase;
import com.mysema.query.types.path.PathInits;
import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class ListPath<E, Q extends SimpleExpression<? super E>>
extends CollectionPathBase<List<E>, E, Q>
implements ListExpression<E, Q> {
    private static final long serialVersionUID = 3302301599074388860L;
    private final Map<Integer, Q> cache = new HashMap<Integer, Q>();
    private final Class<E> elementType;
    private final PathImpl<List<E>> pathMixin;
    private final Class<Q> queryType;
    @Nullable
    private transient Q any;

    public ListPath(Class<? super E> elementType, Class<Q> queryType, String variable) {
        this(elementType, queryType, PathMetadataFactory.forVariable(variable));
    }

    public ListPath(Class<? super E> elementType, Class<Q> queryType, Path<?> parent, String property) {
        this(elementType, queryType, PathMetadataFactory.forProperty(parent, property));
    }

    public ListPath(Class<? super E> elementType, Class<Q> queryType, PathMetadata<?> metadata) {
        this(elementType, queryType, metadata, PathInits.DIRECT);
    }

    public ListPath(Class<? super E> elementType, Class<Q> queryType, PathMetadata<?> metadata, PathInits inits) {
        super(new ParametrizedPathImpl<List>(List.class, metadata, elementType), inits);
        this.elementType = elementType;
        this.queryType = queryType;
        this.pathMixin = (PathImpl)this.mixin;
    }

    @Override
    public final <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this.pathMixin, context);
    }

    @Override
    public Q any() {
        if (this.any == null) {
            this.any = this.newInstance(this.queryType, PathMetadataFactory.forCollectionAny(this));
        }
        return this.any;
    }

    protected PathMetadata<Integer> forListAccess(int index) {
        return PathMetadataFactory.forListAccess(this, index);
    }

    protected PathMetadata<Integer> forListAccess(Expression<Integer> index) {
        return PathMetadataFactory.forListAccess(this, index);
    }

    private Q create(int index) {
        PathMetadata<Integer> md = this.forListAccess(index);
        return this.newInstance(this.queryType, md);
    }

    @Override
    public Q get(Expression<Integer> index) {
        PathMetadata<Integer> md = this.forListAccess(index);
        return this.newInstance(this.queryType, md);
    }

    @Override
    public Q get(int index) {
        if (this.cache.containsKey(index)) {
            return (Q)((SimpleExpression)this.cache.get(index));
        }
        Q rv = this.create(index);
        this.cache.put(index, rv);
        return rv;
    }

    @Override
    public Class<E> getElementType() {
        return this.elementType;
    }

    @Override
    public PathMetadata<?> getMetadata() {
        return this.pathMixin.getMetadata();
    }

    @Override
    public Path<?> getRoot() {
        return this.pathMixin.getRoot();
    }

    @Override
    public AnnotatedElement getAnnotatedElement() {
        return this.pathMixin.getAnnotatedElement();
    }

    @Override
    public Class<?> getParameter(int index) {
        if (index == 0) {
            return this.elementType;
        }
        throw new IndexOutOfBoundsException(String.valueOf(index));
    }
}

