/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nablarch.common.web.hiddenencryption.TamperingDetectedException;

public class ParamsConvertor {
    private final char paramSeparator;
    private final char nameValueSeparator;
    private final char escapeChar;

    public ParamsConvertor(char paramSeparator, char nameValueSeparator, char escapeChar) {
        this.paramSeparator = paramSeparator;
        this.nameValueSeparator = nameValueSeparator;
        this.escapeChar = escapeChar;
    }

    public String convert(Map<String, List<String>> params) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<String>> param : params.entrySet()) {
            for (String value : param.getValue()) {
                if (sb.length() != 0) {
                    sb.append(this.paramSeparator);
                }
                this.escape(sb, param.getKey());
                sb.append(this.nameValueSeparator);
                this.escape(sb, value);
            }
        }
        return sb.toString();
    }

    private void escape(StringBuilder sb, String target) {
        char[] str;
        for (char c : str = target.toCharArray()) {
            if (c == this.escapeChar) {
                sb.append(this.escapeChar).append(this.escapeChar);
                continue;
            }
            if (c == this.paramSeparator) {
                sb.append(this.escapeChar).append(this.paramSeparator);
                continue;
            }
            if (c == this.nameValueSeparator) {
                sb.append(this.escapeChar).append(this.nameValueSeparator);
                continue;
            }
            sb.append(c);
        }
    }

    public Map<String, List<String>> convert(String params) {
        HashMap<String, List<String>> paramsMap = new HashMap<String, List<String>>();
        StringBuilder param = new StringBuilder();
        char[] paramStr = params.toCharArray();
        try {
            for (int i = 0; i < paramStr.length; ++i) {
                if (this.isParamSeparator(paramStr, i)) {
                    this.unescapeNameValue(paramsMap, param);
                    param = new StringBuilder();
                    continue;
                }
                param.append(paramStr[i]);
            }
            this.unescapeNameValue(paramsMap, param);
            return paramsMap;
        }
        catch (RuntimeException e) {
            throw new TamperingDetectedException(String.format("failed to convert. params = [%s], param = [%s]", params, param), e);
        }
    }

    private void unescapeNameValue(Map<String, List<String>> listParams, StringBuilder param) {
        StringBuilder name = new StringBuilder();
        StringBuilder value = new StringBuilder();
        boolean separatorFound = false;
        char[] nameValueStr = param.toString().toCharArray();
        for (int i = 0; i < nameValueStr.length; ++i) {
            char nameValueChar = nameValueStr[i];
            if (nameValueChar == this.escapeChar) {
                char next = nameValueStr[i + 1];
                if (next == this.escapeChar) {
                    nameValueChar = this.escapeChar;
                } else if (next == this.paramSeparator) {
                    nameValueChar = this.paramSeparator;
                } else if (next == this.nameValueSeparator) {
                    nameValueChar = this.nameValueSeparator;
                } else {
                    throw new IllegalArgumentException(String.format("invalid escape sequence was found. nameValueStr = [%s]", String.valueOf(nameValueStr)));
                }
                ++i;
            } else if (nameValueChar == this.nameValueSeparator) {
                separatorFound = true;
                continue;
            }
            if (separatorFound) {
                value.append(nameValueChar);
                continue;
            }
            name.append(nameValueChar);
        }
        if (!separatorFound) {
            throw new IllegalArgumentException(String.format("invalid escape sequence was found. nameValueStr = [%s]", String.valueOf(nameValueStr)));
        }
        String key = name.toString();
        if (!listParams.containsKey(key)) {
            listParams.put(key, new ArrayList());
        }
        listParams.get(key).add(value.toString());
    }

    private boolean isParamSeparator(char[] str, int index) {
        boolean isParamSeparator;
        if (str[index] != this.paramSeparator) {
            return false;
        }
        if (index == 0) {
            throw new IllegalArgumentException(String.format("invalid escape sequence was found. str = [%s]", String.valueOf(str)));
        }
        if (str[index - 1] == this.escapeChar) {
            int escapeCount = 0;
            for (int i = index - 1; i >= 0 && str[i] == this.escapeChar; --i) {
                ++escapeCount;
            }
            isParamSeparator = escapeCount % 2 == 0;
        } else {
            isParamSeparator = true;
        }
        if (isParamSeparator && index == str.length - 1) {
            throw new IllegalArgumentException(String.format("invalid escape sequence was found. str = [%s]", String.valueOf(str)));
        }
        return isParamSeparator;
    }
}

