/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.web.compositekey;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import nablarch.common.web.compositekey.CompositeKey;
import nablarch.common.web.compositekey.CompositeKeyType;
import nablarch.core.util.StringUtil;
import nablarch.core.validation.Convertor;
import nablarch.core.validation.ValidationContext;
import nablarch.core.validation.ValidationResultMessageUtil;

public class CompositeKeyConvertor
implements Convertor {
    private String conversionFailedMessageId;

    public Class<?> getTargetClass() {
        return CompositeKey.class;
    }

    public void setConversionFailedMessageId(String conversionFailedMessageId) {
        this.conversionFailedMessageId = conversionFailedMessageId;
    }

    public <T> boolean isConvertible(ValidationContext<T> context, String propertyName, Object propertyDisplayName, Object value, Annotation format) {
        boolean convertible = false;
        if (format == null) {
            throw new IllegalArgumentException("annotation was not specified. conversion of " + CompositeKey.class.getName() + " requires annotation " + CompositeKeyType.class.getName() + "." + " propertyName = [" + propertyName + "]");
        }
        if (!(format instanceof CompositeKeyType)) {
            throw new IllegalArgumentException("illegal annotation type was specified. conversion of " + CompositeKey.class.getName() + " requires annotation " + CompositeKeyType.class.getName() + "." + " propertyName = [" + propertyName + "]");
        }
        CompositeKeyType compositeKeyType = (CompositeKeyType)format;
        if (value == null) {
            return true;
        }
        if (value instanceof String[] && ((String[])value).length == 1) {
            int keySize = StringUtil.split((String)((String[])value)[0], (String)",").size();
            boolean bl = convertible = compositeKeyType.keySize() == keySize;
        }
        if (!convertible) {
            ValidationResultMessageUtil.addResultMessage(context, (String)propertyName, (String)this.conversionFailedMessageId, (Object)propertyDisplayName, (Object[])new Object[0]);
        }
        return convertible;
    }

    public <T> Object convert(ValidationContext<T> context, String propertyName, Object value, Annotation format) {
        if (value == null) {
            return null;
        }
        List split = StringUtil.split((String)((String[])value)[0], (String)",");
        return new CompositeKey(StringUtil.toArray((Collection)split));
    }
}

