/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.web.handler;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Handler;
import nablarch.fw.web.HttpErrorResponse;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.handler.HttpAccessLogFormatter;
import nablarch.fw.web.handler.HttpAccessLogUtil;
import nablarch.fw.web.servlet.ServletExecutionContext;

public class HttpAccessLogHandler
implements Handler<HttpRequest, HttpResponse> {
    private static final Object[] EMPTY_OPTIONS = new Object[0];

    public HttpAccessLogHandler() {
        HttpAccessLogUtil.initialize();
    }

    public HttpResponse handle(HttpRequest req, ExecutionContext context) throws ClassCastException {
        ServletExecutionContext ctx = (ServletExecutionContext)context;
        HttpAccessLogFormatter.HttpAccessLogContext logContext = HttpAccessLogUtil.getAccessLogContext(req, ctx);
        this.writeBeginLog(req, ctx, logContext);
        HttpResponse response = null;
        try {
            response = (HttpResponse)context.handleNext((Object)req);
        }
        catch (HttpErrorResponse errorResponse) {
            response = errorResponse.getResponse();
            throw errorResponse;
        }
        finally {
            this.writeEndLog(req, ctx, logContext, response);
        }
        return response;
    }

    protected void writeBeginLog(HttpRequest request, ServletExecutionContext context, HttpAccessLogFormatter.HttpAccessLogContext logContext) {
        Object[] requestLogOptions = this.getRequestOptions(request, context);
        HttpAccessLogUtil.begin(logContext, requestLogOptions);
        if (HttpAccessLogUtil.containsMemoryItem()) {
            MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
            MemoryUsage heapMemory = memory.getHeapMemoryUsage();
            long max = heapMemory.getMax();
            logContext.setMaxMemory(max);
            logContext.setFreeMemory(max - heapMemory.getUsed());
        }
        logContext.setStartTime(System.currentTimeMillis());
    }

    protected void writeEndLog(HttpRequest request, ServletExecutionContext context, HttpAccessLogFormatter.HttpAccessLogContext logContext, HttpResponse response) {
        logContext.setEndTime(System.currentTimeMillis());
        if (response != null) {
            logContext.setResponse(response);
        }
        Object[] responseOptions = this.getResponseOptions(request, response, context);
        HttpAccessLogUtil.end(logContext, responseOptions);
    }

    protected Object[] getRequestOptions(HttpRequest request, ExecutionContext context) {
        return EMPTY_OPTIONS;
    }

    protected Object[] getResponseOptions(HttpRequest request, HttpResponse response, ExecutionContext context) {
        return EMPTY_OPTIONS;
    }
}

