/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.web.handler.threadcontext;

import java.util.TimeZone;
import nablarch.common.web.handler.threadcontext.TimeZoneAttributeInHttpSupport;
import nablarch.core.ThreadContext;
import nablarch.core.repository.SystemRepository;
import nablarch.core.util.annotation.Published;
import nablarch.fw.ExecutionContext;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.servlet.ServletExecutionContext;

@Published(tag={"architect"})
public final class TimeZoneAttributeInHttpUtil {
    private static final String TIMEZONE_ATTRIBUTE_COMPONENT_NAME = "timeZoneAttribute";

    private TimeZoneAttributeInHttpUtil() {
    }

    @Published(tag={"architect"})
    public static void keepTimeZone(HttpRequest request, ExecutionContext context, String timeZone) {
        TimeZoneAttributeInHttpSupport support = (TimeZoneAttributeInHttpSupport)((Object)SystemRepository.get((String)TIMEZONE_ATTRIBUTE_COMPONENT_NAME));
        if (support == null) {
            throw new IllegalArgumentException("specified timeZoneAttribute is not registered in SystemRepository.");
        }
        if (!support.isSupportedTimeZone(timeZone)) {
            return;
        }
        support.keepTimeZone(request, (ServletExecutionContext)context, timeZone);
        ThreadContext.setTimeZone((TimeZone)TimeZone.getTimeZone(timeZone));
    }
}

