/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.web.session;

import java.util.ArrayList;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nablarch.common.web.session.Session;
import nablarch.common.web.session.SessionEntry;
import nablarch.common.web.session.SessionManager;
import nablarch.common.web.session.SessionStore;
import nablarch.common.web.session.store.HiddenStore;
import nablarch.core.date.SystemTimeUtil;
import nablarch.core.util.StringUtil;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Handler;
import nablarch.fw.web.HttpCookie;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.servlet.ServletExecutionContext;

public class SessionStoreHandler
implements Handler<Object, Object> {
    private SessionManager sessionManager;
    private String cookieName = "NABLARCH_SID";
    private String cookiePath = "/";
    private String cookieDomain;
    private boolean cookieSecure = false;
    public static final String IS_INVALIDATED_KEY = "nablarch_sessionStore_is_invalidated";
    private static final String EXPIRATION_DATE_KEY = "nablarch_sessionStore_expiration_date";

    private boolean isInvalidated(ExecutionContext ctx) {
        return ctx.getSessionStoredVar(IS_INVALIDATED_KEY) != null;
    }

    protected HttpResponse handleLoadFailed(Object data, ExecutionContext context, RuntimeException e) {
        if (e instanceof HiddenStore.HiddenStoreLoadFailedException) {
            context.setException((Throwable)e);
            return HttpResponse.Status.BAD_REQUEST.handle((HttpRequest)data, context);
        }
        throw e;
    }

    public Object handle(Object data, ExecutionContext context) {
        SessionEntry entry;
        Session session = null;
        ArrayList<String> entryKeys = new ArrayList<String>();
        ServletExecutionContext servletContext = (ServletExecutionContext)context;
        String sessionId = this.readId(servletContext);
        if (sessionId != null) {
            session = this.sessionManager.create(context);
            try {
                session.load(sessionId);
            }
            catch (RuntimeException e) {
                return this.handleLoadFailed(data, servletContext, e);
            }
            for (SessionEntry sessionEntry : session) {
                entryKeys.add(sessionEntry.getKey());
                context.setSessionStoredVar(sessionEntry.getKey(), (Object)sessionEntry);
            }
        }
        Object res = context.handleNext(data);
        if (sessionId != null && servletContext.getNativeHttpSession(false) == null) {
            return res;
        }
        if (this.isInvalidated(context)) {
            SessionStoreHandler.invalidateHttpSession(servletContext);
            if (session != null) {
                session.invalidate();
            }
        }
        for (Object sessionStoreVar : context.getSessionStoreMap().values()) {
            if (!(sessionStoreVar instanceof SessionEntry)) continue;
            if (session == null) {
                session = this.sessionManager.create(context);
            }
            entry = (SessionEntry)sessionStoreVar;
            session.put(entry);
        }
        if (session != null) {
            for (String entryKey : entryKeys) {
                entry = context.getSessionStoreMap().get(entryKey);
                if (null != entry && entry instanceof SessionEntry) continue;
                session.delete(entryKey);
            }
            session.save();
            this.writeId(session, servletContext);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invalidateHttpSession(ServletExecutionContext context) {
        HttpSession session = context.getNativeHttpSession(false);
        if (session == null) {
            return;
        }
        HttpSession httpSession = session;
        synchronized (httpSession) {
            session.invalidate();
        }
    }

    protected void writeId(Session session, ServletExecutionContext context) {
        long maxAge = 0L;
        for (SessionStore store : session.getSessionFactory().getAvailableStores()) {
            if (!store.isExtendable()) continue;
            maxAge = Math.max(maxAge, store.getExpiresMilliSeconds());
        }
        context.setSessionScopedVar(EXPIRATION_DATE_KEY, SystemTimeUtil.getTimestamp().getTime() + maxAge);
        this.setSessionTrackingCookie(session, context.getServletResponse());
    }

    protected void setSessionTrackingCookie(Session session, HttpServletResponse response) {
        HttpCookie cookie = new HttpCookie();
        cookie.put(this.cookieName, session.getOrGenerateId());
        cookie.setPath(this.cookiePath);
        if (!StringUtil.isNullOrEmpty((String)this.cookieDomain)) {
            cookie.setDomain(this.cookieDomain);
        }
        if (cookie.supportsHttpOnly()) {
            cookie.setHttpOnly(true);
        }
        cookie.setSecure(this.cookieSecure);
        for (Cookie c : cookie.convertServletCookies()) {
            response.addCookie(c);
        }
    }

    protected String readId(ServletExecutionContext context) {
        if (!this.isValidExpirationDate((Long)context.getSessionScopedVar(EXPIRATION_DATE_KEY))) {
            return null;
        }
        return this.getSessionId(context);
    }

    private boolean isValidExpirationDate(Long expirationDate) {
        Long timestamp = SystemTimeUtil.getTimestamp().getTime();
        return expirationDate != null && expirationDate >= timestamp;
    }

    private String getSessionId(ServletExecutionContext context) {
        Cookie[] cookies = context.getServletRequest().getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!this.cookieName.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public void setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
    }

    public void setCookieDomain(String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    public void setCookieSecure(boolean cookieSecure) {
        this.cookieSecure = cookieSecure;
    }
}

