/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.web.session;

import java.util.NoSuchElementException;
import nablarch.common.web.session.SessionEntry;
import nablarch.common.web.session.SessionManager;
import nablarch.core.repository.SystemRepository;
import nablarch.core.util.annotation.Published;
import nablarch.fw.ExecutionContext;

@Published
public final class SessionUtil {
    private SessionUtil() {
    }

    public static <T> T get(ExecutionContext ctx, String name) {
        T value = SessionUtil.getSessionValue(ctx, name);
        if (value != null) {
            return value;
        }
        throw new NoSuchElementException();
    }

    public static <T> T orNull(ExecutionContext ctx, String name) {
        return SessionUtil.getSessionValue(ctx, name);
    }

    public static <T> T or(ExecutionContext ctx, String name, T defaultValue) {
        T value = SessionUtil.getSessionValue(ctx, name);
        return value != null ? value : defaultValue;
    }

    private static <T> T getSessionValue(ExecutionContext ctx, String name) {
        Object value = ctx.getSessionStoredVar(name);
        if (value instanceof SessionEntry) {
            return (T)((SessionEntry)SessionEntry.class.cast(value)).getValue();
        }
        return null;
    }

    public static void put(ExecutionContext ctx, String name, Object value) {
        ctx.setSessionStoredVar(name, (Object)new SessionEntry(name, value, SessionUtil.getSessionManager().getDefaultStore()));
    }

    public static void put(ExecutionContext ctx, String name, Object value, String storeName) {
        ctx.setSessionStoredVar(name, (Object)new SessionEntry(name, value, SessionUtil.getSessionManager().findSessionStore(storeName)));
    }

    private static SessionManager getSessionManager() {
        return (SessionManager)SystemRepository.get((String)"sessionManager");
    }

    public static <T> T delete(ExecutionContext ctx, String name) {
        Object sessionStoredVar = ctx.getSessionStoredVar(name);
        if (sessionStoredVar instanceof SessionEntry) {
            Object value = ((SessionEntry)sessionStoredVar).getValue();
            ctx.setSessionStoredVar(name, value);
            return (T)value;
        }
        return null;
    }

    public static void invalidate(ExecutionContext ctx) {
        for (String key : ctx.getSessionStoreMap().keySet()) {
            SessionUtil.delete(ctx, key);
        }
        ctx.setSessionStoredVar("nablarch_sessionStore_is_invalidated", (Object)Boolean.TRUE);
    }
}

