/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.web.session.encoder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import nablarch.common.encryption.AesEncryptor;
import nablarch.common.encryption.Encryptor;
import nablarch.common.web.session.EncodeException;
import nablarch.common.web.session.StateEncoder;

public class JavaSerializeEncryptStateEncoder<C extends Serializable>
implements StateEncoder {
    private Encryptor<C> encryptor;
    private C encryptContext;

    public JavaSerializeEncryptStateEncoder() {
        this.setEncryptor((Encryptor<C>)new AesEncryptor());
    }

    public void setEncryptor(Encryptor<C> encryptor) {
        this.encryptor = encryptor;
        this.encryptContext = encryptor.generateContext();
    }

    @Override
    public <T> byte[] encode(T obj) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            return this.encryptor.encrypt(this.encryptContext, baos.toByteArray());
        }
        catch (IOException e) {
            throw new EncodeException(e);
        }
    }

    @Override
    public <T> T decode(byte[] dmp, Class<T> type) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.encryptor.decrypt(this.encryptContext, dmp));
            ObjectInputStream ois = new ObjectInputStream(bais);
            return (T)ois.readObject();
        }
        catch (Exception e) {
            throw new EncodeException(e);
        }
    }
}

