/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.web.session.encoder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.xml.bind.JAXB;
import nablarch.common.web.session.EncodeException;
import nablarch.common.web.session.StateEncoder;
import nablarch.core.util.FileUtil;

public class JaxbStateEncoder
implements StateEncoder {
    @Override
    public <T> byte[] encode(T obj) {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            JAXB.marshal(obj, (Writer)writer);
            byArray = baos.toByteArray();
        }
        catch (IOException ex) {
            try {
                throw new EncodeException(ex);
            }
            catch (Throwable throwable) {
                FileUtil.closeQuietly((Closeable[])new Closeable[]{writer});
                throw throwable;
            }
        }
        FileUtil.closeQuietly((Closeable[])new Closeable[]{writer});
        return byArray;
    }

    @Override
    public <T> T decode(byte[] dmp, Class<T> type) {
        Object object;
        ByteArrayInputStream bais = new ByteArrayInputStream(dmp);
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)bais, "UTF-8");
            object = JAXB.unmarshal((Reader)reader, type);
        }
        catch (IOException ex) {
            try {
                throw new EncodeException(ex);
            }
            catch (Throwable throwable) {
                FileUtil.closeQuietly((Closeable[])new Closeable[]{reader});
                throw throwable;
            }
        }
        FileUtil.closeQuietly((Closeable[])new Closeable[]{reader});
        return (T)object;
    }
}

