/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.web.session.store;

import java.util.Collections;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import nablarch.common.web.session.EncodeException;
import nablarch.common.web.session.SessionEntry;
import nablarch.common.web.session.SessionStore;
import nablarch.fw.ExecutionContext;
import nablarch.fw.web.servlet.ServletExecutionContext;

public class HiddenStore
extends SessionStore {
    private String parameterName = "nablarch_hiddenStore";

    public HiddenStore() {
        super("hidden");
    }

    @Override
    public List<SessionEntry> load(String sessionId, ExecutionContext executionContext) {
        ServletExecutionContext servlet = (ServletExecutionContext)executionContext;
        String[] hiddenValue = servlet.getHttpRequest().getParam(this.parameterName);
        if (hiddenValue != null) {
            try {
                byte[] src = DatatypeConverter.parseBase64Binary((String)hiddenValue[0]);
                return this.decode(src);
            }
            catch (Exception e) {
                throw new HiddenStoreLoadFailedException(e);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void save(String sessionId, List<SessionEntry> entries, ExecutionContext executionContext) {
        byte[] src = this.encode(entries);
        String parameterValue = DatatypeConverter.printBase64Binary((byte[])src);
        executionContext.setRequestScopedVar(this.parameterName, (Object)parameterValue);
    }

    @Override
    public void delete(String sessionId, ExecutionContext executionContext) {
        executionContext.getRequestScopeMap().remove(this.parameterName);
    }

    @Override
    public void invalidate(String sessionId, ExecutionContext executionContext) {
        executionContext.getRequestScopeMap().remove(this.parameterName);
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public static class HiddenStoreLoadFailedException
    extends EncodeException {
        public HiddenStoreLoadFailedException(Exception cause) {
            super(cause);
        }
    }
}

