/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.web.session.store;

import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpSession;
import javax.xml.bind.DatatypeConverter;
import nablarch.common.web.session.SessionEntry;
import nablarch.common.web.session.SessionStore;
import nablarch.fw.ExecutionContext;
import nablarch.fw.web.servlet.ServletExecutionContext;

public class HttpSessionStore
extends SessionStore {
    public HttpSessionStore() {
        super("httpSession");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SessionEntry> load(String sessionId, ExecutionContext executionContext) {
        String entries;
        if (!executionContext.hasSession()) {
            return Collections.emptyList();
        }
        HttpSession httpSession = this.getNativeSession(executionContext);
        synchronized (httpSession) {
            entries = (String)executionContext.getSessionScopedVar(sessionId);
        }
        if (entries != null) {
            return this.decode(DatatypeConverter.parseBase64Binary((String)entries));
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(String sessionId, List<SessionEntry> entries, ExecutionContext executionContext) {
        String entriesBinary = DatatypeConverter.printBase64Binary((byte[])this.encode(entries));
        HttpSession httpSession = this.getNativeSession(executionContext);
        synchronized (httpSession) {
            executionContext.setSessionScopedVar(sessionId, (Object)entriesBinary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String sessionId, ExecutionContext executionContext) {
        if (!executionContext.hasSession()) {
            return;
        }
        HttpSession httpSession = this.getNativeSession(executionContext);
        synchronized (httpSession) {
            executionContext.getSessionScopeMap().remove(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(String sessionId, ExecutionContext executionContext) {
        if (!executionContext.hasSession()) {
            return;
        }
        HttpSession httpSession = this.getNativeSession(executionContext);
        synchronized (httpSession) {
            executionContext.invalidateSession();
        }
    }

    private HttpSession getNativeSession(ExecutionContext ctx) {
        return ((ServletExecutionContext)ctx).getNativeHttpSession(true);
    }
}

