/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.web.validator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.validation.Validator;
import nablarch.common.web.interceptor.InjectForm;
import nablarch.common.web.validator.ValidationStrategy;
import nablarch.core.beans.BeanUtil;
import nablarch.core.message.ApplicationException;
import nablarch.core.message.Message;
import nablarch.core.util.StringUtil;
import nablarch.core.util.annotation.Published;
import nablarch.core.validation.ValidationResultMessage;
import nablarch.core.validation.ee.ConstraintViolationConverterFactory;
import nablarch.core.validation.ee.ValidatorUtil;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.servlet.ServletExecutionContext;

public class BeanValidationStrategy
implements ValidationStrategy {
    @Published(tag={"architect"})
    public BeanValidationStrategy() {
    }

    @Override
    public Serializable validate(HttpRequest request, InjectForm annotation, boolean notUse, ServletExecutionContext context) {
        Map<String, String[]> rawRequestParamMap = request.getParamMap();
        Map<String, String[]> requestParamMap = this.getMapWithConvertedKey(annotation.prefix(), rawRequestParamMap);
        Serializable bean = (Serializable)BeanUtil.createAndCopy(annotation.form(), requestParamMap);
        Validator validator = ValidatorUtil.getValidator();
        Set results = validator.validate((Object)bean, new Class[0]);
        if (!results.isEmpty()) {
            List messages = new ConstraintViolationConverterFactory().create(annotation.prefix()).convert(results);
            throw new ApplicationException(BeanValidationStrategy.sortMessages(messages, context, annotation));
        }
        return bean;
    }

    @Published(tag={"architect"})
    protected static List<Message> sortMessages(List<Message> messages, ServletExecutionContext context, InjectForm injectForm) {
        ServletRequest request = context.getServletRequest().getRequest();
        final ArrayList parameterNames = Collections.list(request.getParameterNames());
        ArrayList<Message> sortedMessage = new ArrayList<Message>(messages);
        Collections.sort(sortedMessage, new Comparator<Message>(){

            @Override
            public int compare(Message m1, Message m2) {
                int index2;
                int index1 = BeanValidationStrategy.getParameterIndex(parameterNames, m1);
                if (index1 < (index2 = BeanValidationStrategy.getParameterIndex(parameterNames, m2))) {
                    return -1;
                }
                if (index2 < index1) {
                    return 1;
                }
                return 0;
            }
        });
        return sortedMessage;
    }

    private static int getParameterIndex(List<String> parameterNames, Message message) {
        if (message instanceof ValidationResultMessage) {
            int index = parameterNames.indexOf(((ValidationResultMessage)message).getPropertyName());
            return index == -1 ? Integer.MAX_VALUE : index;
        }
        return Integer.MAX_VALUE;
    }

    private Map<String, String[]> getMapWithConvertedKey(String prefix, Map<String, String[]> reqParamMap) {
        if (StringUtil.isNullOrEmpty((String)prefix)) {
            return new HashMap<String, String[]>(reqParamMap);
        }
        String prefixName = prefix + '.';
        int prefixLength = prefixName.length();
        HashMap<String, String[]> convertedMap = new HashMap<String, String[]>();
        for (Map.Entry<String, String[]> entry : reqParamMap.entrySet()) {
            String key = entry.getKey();
            String[] value = entry.getValue();
            if (!key.startsWith(prefixName)) continue;
            convertedMap.put(key.substring(prefixLength), value);
        }
        return convertedMap;
    }
}

