/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.http.Cookie;
import nablarch.core.util.StringUtil;
import nablarch.core.util.annotation.Published;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Result;
import nablarch.fw.web.HttpCookie;
import nablarch.fw.web.HttpErrorResponse;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpRequestHandler;
import nablarch.fw.web.ResourceLocator;
import nablarch.fw.web.ResponseBody;

public class HttpResponse
implements Result {
    public static final String LS = "\r\n";
    private static final Charset ASCII = Charset.forName("iso-8859-1");
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Pattern CHARSET_ATTR_IN_CONTENT_PATH = Pattern.compile("^.*?;\\s*charset=\\s*\"?(.*?)\"?\\s*$(;.*)?");
    private boolean wasBytes = false;
    private Status status = Status.OK;
    private String httpVersion = "HTTP/1.1";
    private static final Pattern HTTP_VERSION_SYNTAX = Pattern.compile("HTTP/(0\\.9|1\\.0|1\\.1)");
    private Map<String, String> headers = null;
    private Charset charset = null;
    protected static final String CONTENT_DISPOSITION = "Content-Disposition";
    private final List<Cookie> cookies;
    static final MimetypesFileTypeMap MAGIC = new MimetypesFileTypeMap();
    private ResponseBody body = new ResponseBody(this);
    private static final Pattern HTTP_HEADER_SYNTAX;
    private static final Pattern HTTP_STATUS_CODE_SYNTAX;

    @Published
    public HttpResponse() {
        this(200);
    }

    @Published
    public HttpResponse(int statusCode) {
        this.setStatusCode(statusCode);
        this.headers = new HashMap<String, String>();
        this.cookies = new ArrayList<Cookie>();
    }

    @Published
    public HttpResponse(int statusCode, String contentPath) {
        this(statusCode);
        this.setContentPath(contentPath);
    }

    @Published
    public HttpResponse(String contentPath) {
        this(200, contentPath);
    }

    public static HttpResponse parse(String message) {
        HttpResponse result = new HttpResponse();
        result.parseMessage(new StringReader(message));
        return result;
    }

    public static HttpResponse parse(byte[] message) {
        HttpResponse result = new HttpResponse();
        result.wasBytes = true;
        result.parseMessage(new StringReader(StringUtil.toString((byte[])message, (Charset)ASCII)));
        return result;
    }

    @Published
    public int getStatusCode() {
        if (this.body != null && this.body.getContentPath() != null && this.body.getContentPath().isRedirect()) {
            return Status.FOUND.code;
        }
        return this.status.code;
    }

    @Published
    public HttpResponse setStatusCode(int code) {
        if (code < 100 || code > 999) {
            throw new IllegalArgumentException("invalid status code:" + code);
        }
        this.status = Status.valueOfCode(code);
        return this;
    }

    @Published
    public String getReasonPhrase() {
        return this.status.phrase;
    }

    @Published
    public String getMessage() {
        return String.valueOf(this.status.code) + ": " + this.getReasonPhrase();
    }

    @Published
    public String getHttpVersion() {
        return this.httpVersion;
    }

    public HttpResponse setHttpVersion(String httpVersion) {
        if (!HTTP_VERSION_SYNTAX.matcher(httpVersion).matches()) {
            throw new IllegalArgumentException("invalid : " + httpVersion);
        }
        this.httpVersion = httpVersion;
        return this;
    }

    @Published
    public Map<String, String> getHeaderMap() {
        this.getContentLength();
        this.getContentType();
        return this.headers;
    }

    @Published
    public String getHeader(String headerName) {
        return this.headers.get(headerName);
    }

    @Published
    public void setHeader(String headerName, String value) {
        this.headers.put(headerName, value);
    }

    @Published
    public String getContentType() {
        String contentType = this.headers.get("Content-Type");
        if (contentType == null) {
            this.headers.put("Content-Type", "text/plain;charset=UTF-8");
        }
        return this.headers.get("Content-Type");
    }

    public Charset getCharset() {
        if (this.charset == null) {
            String contentType = this.getContentType();
            Matcher mt = CHARSET_ATTR_IN_CONTENT_PATH.matcher(contentType);
            this.charset = mt.matches() ? Charset.forName(mt.group(1)) : UTF_8;
        }
        return this.charset;
    }

    @Published
    public HttpResponse setContentType(String contentType) {
        this.getHeaderMap().put("Content-Type", contentType);
        this.charset = null;
        return this;
    }

    @Published
    public String getLocation() {
        return this.headers.get("Location");
    }

    @Published
    public HttpResponse setLocation(String location) {
        this.headers.put("Location", location);
        return this;
    }

    @Published
    public HttpResponse setContentDisposition(String fileName) {
        this.setContentDisposition(fileName, false);
        return this;
    }

    @Published
    public HttpResponse setContentDisposition(String fileName, boolean inline) {
        if (this.headers.get("Content-Type") == null) {
            this.headers.put("Content-Type", MAGIC.getContentType(fileName));
        }
        this.setHeader(CONTENT_DISPOSITION, (inline ? "inline" : "attachment") + (fileName == null ? "" : "; filename=\"" + fileName + "\""));
        return this;
    }

    @Published(tag={"architect"})
    public String getContentDisposition() {
        return this.headers.get(CONTENT_DISPOSITION);
    }

    public String getTransferEncoding() {
        return this.headers.get("Transfer-Encoding");
    }

    public HttpResponse setTransferEncoding(String encoding) {
        this.headers.put("Transfer-Encoding", encoding);
        return this;
    }

    @Published
    @Deprecated
    public HttpCookie getCookie() {
        if (this.cookies.isEmpty()) {
            return null;
        }
        Cookie servletCookie = this.cookies.get(0);
        HttpCookie cookie = new HttpCookie();
        cookie.put(servletCookie.getName(), servletCookie.getValue());
        return cookie;
    }

    public List<Cookie> getCookieList() {
        return this.cookies;
    }

    @Published
    @Deprecated
    public HttpResponse setCookie(HttpCookie cookie) {
        return this.addCookie(cookie);
    }

    @Published
    public HttpResponse addCookie(HttpCookie cookie) {
        this.cookies.addAll(cookie.convertServletCookies());
        return this;
    }

    @Published
    public HttpResponse setContentPath(String path) {
        this.setContentPath(ResourceLocator.valueOf(path));
        return this;
    }

    @Published
    public HttpResponse setContentPath(ResourceLocator resource) {
        if (resource != null) {
            this.setContentType(MAGIC.getContentType(resource.getResourceName()));
        }
        this.body.setContentPath(resource);
        return this;
    }

    @Published
    public ResourceLocator getContentPath() {
        return this.body.getContentPath();
    }

    @Published
    public String getContentLength() {
        Long length = this.body.length();
        if (length == null) {
            return null;
        }
        String val = String.valueOf(length);
        this.headers.put("Content-Length", val);
        return val;
    }

    public HttpResponse cleanup() {
        ResponseBody.cleanup();
        return this;
    }

    @Published(tag={"architect"})
    public boolean isBodyEmpty() {
        return this.body.isEmpty();
    }

    @Published(tag={"architect"})
    public String getBodyString() {
        return this.body.toString();
    }

    @Published(tag={"architect"})
    public InputStream getBodyStream() {
        return this.body.getInputStream();
    }

    @Published(tag={"architect"})
    public HttpResponse setBodyStream(InputStream bodyStream) {
        this.body.setInputStream(bodyStream);
        return this;
    }

    @Published
    public HttpResponse write(CharSequence text) throws HttpErrorResponse {
        this.body.write(text);
        return this;
    }

    @Published
    public HttpResponse write(byte[] bytes) throws HttpErrorResponse {
        this.body.write(bytes);
        return this;
    }

    @Published
    public HttpResponse write(ByteBuffer bytes) throws HttpErrorResponse {
        this.body.write(bytes);
        return this;
    }

    public String toString() {
        String statusLine = String.format("%s %s %s", this.getHttpVersion(), this.getStatusCode(), this.getReasonPhrase());
        StringBuilder buffer = new StringBuilder(statusLine).append(LS);
        Iterator<Map.Entry<String, String>> entries = this.getHeaderMap().entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, String> header = entries.next();
            if (header.getKey().equals("Transfer-Encoding")) continue;
            buffer.append(header.getKey()).append(": ").append(header.getValue());
            if (!entries.hasNext()) continue;
            buffer.append(LS);
        }
        buffer.append("\r\n\r\n").append(this.body.toString());
        return buffer.toString();
    }

    private void parseMessage(Reader source) {
        String transferEncoding;
        String line;
        Scanner responseMessage = new Scanner(source);
        Scanner statusLine = new Scanner(responseMessage.nextLine());
        this.scanHttpVersion(statusLine);
        this.scanHttpStatus(statusLine);
        String header = null;
        while (responseMessage.hasNextLine() && (line = responseMessage.nextLine()).length() != 0) {
            if (header == null) {
                header = line;
                continue;
            }
            if (line.matches("\\s+.*")) {
                header = header + " " + line.trim();
                continue;
            }
            this.scanHttpResponseHeader(header);
            header = line;
        }
        if (header != null) {
            this.scanHttpResponseHeader(header);
        }
        if ((transferEncoding = this.getTransferEncoding()) != null && transferEncoding.equals("chunked")) {
            this.scanChunkedBody(responseMessage);
        } else {
            this.scanResponseBody(responseMessage);
        }
    }

    private void scanResponseBody(Scanner message) {
        String line;
        message.useDelimiter("\\r\\n");
        StringBuilder buffer = new StringBuilder();
        while (message.hasNext() && (line = message.next()) != null) {
            buffer.append(line);
            if (!message.hasNext()) continue;
            buffer.append(LS);
        }
        if (this.wasBytes) {
            this.write(this.getBytes(buffer, ASCII));
        } else {
            this.write(buffer);
        }
    }

    private byte[] getBytes(CharSequence chars, Charset charset) {
        ByteBuffer byteBuffer = charset.encode(CharBuffer.wrap(chars));
        byte[] bytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(bytes);
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanChunkedBody(Scanner message) {
        long chunkSize = -1L;
        StringBuilder buffer = new StringBuilder();
        block3: while (message.hasNextLong(16) && (chunkSize = message.nextLong(16)) > 0L) {
            long readSize = 0L;
            try {
                String chunk;
                message.useDelimiter("\\r\\n");
                while (message.hasNext() && (chunk = message.next()) != null) {
                    buffer.append(chunk);
                    if ((readSize += (long)(this.getBytes(chunk, ASCII).length + 2)) == chunkSize + 2L) continue block3;
                    if (readSize < chunkSize + 2L) {
                        buffer.append(LS);
                        continue;
                    }
                    throw new RuntimeException("malformed chunk.: " + chunk);
                }
            }
            finally {
                message.useDelimiter("\\p{javaWhitespace}+");
            }
        }
        this.write(ASCII.encode(buffer.toString()));
    }

    private void scanHttpResponseHeader(String header) {
        Matcher m = HTTP_HEADER_SYNTAX.matcher(header);
        if (!m.matches()) {
            this.parseError(header);
        }
        this.headers.put(m.group(1), m.group(2));
    }

    private void scanHttpVersion(Scanner scanner) {
        this.httpVersion = scanner.next(HTTP_VERSION_SYNTAX);
    }

    private void scanHttpStatus(Scanner scanner) {
        String statusCode = scanner.next(HTTP_STATUS_CODE_SYNTAX);
        this.status = Status.valueOfCode(Integer.valueOf(statusCode));
    }

    private void parseError(Object obj) {
        throw new RuntimeException("Invalid http request message.: " + obj.toString());
    }

    public boolean isSuccess() {
        return this.getStatusCode() < 400;
    }

    static {
        MAGIC.addMimeTypes("text/css css");
        MAGIC.addMimeTypes("text/plain txt");
        MAGIC.addMimeTypes("text/plain text");
        MAGIC.addMimeTypes("application/excel xls");
        MAGIC.addMimeTypes("application/mspowerpoint ppt");
        MAGIC.addMimeTypes("application/msword doc");
        MAGIC.addMimeTypes("application/pdf pdf");
        MAGIC.addMimeTypes("application/zip zip");
        MAGIC.addMimeTypes("image/jpeg jpg");
        MAGIC.addMimeTypes("image/png png");
        MAGIC.addMimeTypes("image/gif gif");
        HTTP_HEADER_SYNTAX = Pattern.compile("([a-zA-Z0-9\\-]+):\\s(.*)", 32);
        HTTP_STATUS_CODE_SYNTAX = Pattern.compile("[1-5]\\d{2}");
    }

    @Published
    public static enum Status implements HttpRequestHandler
    {
        CONTINUE(100),
        OK(200),
        CREATED(201),
        ACCEPTED(202),
        NO_CONTENT(204),
        RESET_CONTENT(205),
        PARTIAL_CONTENT(206),
        MOVED_PERMANENTLY(301),
        FOUND(302),
        SEE_OTHER(303),
        NOT_MODIFIED(304),
        USE_PROXY(305),
        TEMPORARY_REDIRECT(307),
        BAD_REQUEST(400),
        UNAUTHORIZED(401),
        PAYMENT_REQUIRED(402),
        FORBIDDEN(403),
        NOT_FOUND(404),
        METHOD_NOT_ALLOWED(405),
        NOT_ACCEPTABLE(406),
        PROXY_AUTHENTICATION_REQUIRED(407),
        REQUEST_TIMEOUT(408),
        CONFLICT(409),
        GONE(410),
        LENGTH_REQUIRED(411),
        PRECONDITION_FAILED(412),
        REQUEST_ENTITY_TOO_LARGE(413),
        REQUEST_URI_TOO_LONG(414),
        UNSUPPORTED_MEDIA_TYPE(415),
        REQUESTED_RANGE_NOT_SATISFIABLE(416),
        EXPECTATION_FAILED(417),
        INTERNAL_SERVER_ERROR(500),
        NOT_IMPLEMENTED(501),
        BAD_GATEWAY(502),
        SERVICE_UNAVAILABLE(503),
        GATEWAY_TIMEOUT(504),
        HTTP_VERSION_NOT_SUPPORTED(505);

        private static final Map<Integer, Status> INDEX_BY_CODE;
        private final int code;
        private final String phrase;

        private Status(int code) {
            this.code = code;
            this.phrase = this.name();
        }

        public static Status valueOfCode(int code) throws IllegalArgumentException {
            Status status = INDEX_BY_CODE.get(code);
            if (status == null) {
                throw new IllegalArgumentException("invalid status code.[" + code + "]");
            }
            return status;
        }

        @Override
        public HttpResponse handle(HttpRequest req, ExecutionContext ctx) {
            return new HttpResponse().setStatusCode(this.code);
        }

        public int getStatusCode() {
            return this.code;
        }

        static {
            INDEX_BY_CODE = new HashMap<Integer, Status>();
            for (Status status : Status.values()) {
                INDEX_BY_CODE.put(status.code, status);
            }
        }
    }
}

