/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.util.FileUtil;
import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.HttpResponseSetting;
import nablarch.fw.web.ResourceLocator;

public class ResponseBody {
    private static final Logger LOGGER = LoggerManager.get(ResponseBody.class);
    private static final HttpResponseSetting CONF = new HttpResponseSetting();
    private static final int BSIZE = 16384;
    private final HttpResponse response;
    private ResourceLocator contentPath = null;
    private InputStream input = null;
    private ByteBuffer buffer = null;
    private File tempFile = null;
    private FileChannel tempFileWriteChannel = null;
    private static final ThreadLocal<Collection<File>> TEMP_FILE_HOLDER = new ThreadLocal<Collection<File>>(){

        @Override
        protected Collection<File> initialValue() {
            return new ArrayList<File>();
        }
    };
    private static final ThreadLocal<Collection<Closeable>> STREAM_HOLDER = new ThreadLocal<Collection<Closeable>>(){

        @Override
        protected Collection<Closeable> initialValue() {
            return new ArrayList<Closeable>();
        }
    };

    public ResponseBody(HttpResponse response) {
        this.response = response;
    }

    public boolean isEmpty() {
        return this.contentPath == null && this.input == null && this.tempFile == null && this.buffer == null;
    }

    public Long length() {
        if (this.contentPath != null || this.input != null || this.tempFile != null) {
            return null;
        }
        if (this.buffer != null) {
            return this.buffer.position();
        }
        return 0L;
    }

    public ResponseBody setContentPath(ResourceLocator path) {
        this.contentPath = path;
        return this;
    }

    public ResourceLocator getContentPath() {
        return this.contentPath;
    }

    public ResponseBody write(byte[] bytes) {
        return this.write(ByteBuffer.wrap(bytes));
    }

    public ResponseBody write(CharSequence text) {
        return this.write(this.response.getCharset().encode(CharBuffer.wrap(text)));
    }

    public ResponseBody write(ByteBuffer bytes) {
        int newLimit;
        if (this.tempFile != null) {
            this.writeToFile(bytes);
            return this;
        }
        if (this.buffer == null) {
            this.buffer = ByteBuffer.allocate(16384);
        }
        if ((newLimit = this.buffer.limit() + bytes.remaining()) > CONF.getBufferLimitSizeKb() * 1024) {
            this.writeToFile(bytes);
        } else {
            this.writeToHeapBuffer(bytes);
        }
        return this;
    }

    private void writeToHeapBuffer(ByteBuffer bytes) {
        if (this.buffer.remaining() < bytes.remaining()) {
            this.expandTo(this.buffer.capacity() + bytes.remaining());
        }
        this.buffer.put(bytes);
    }

    private void writeToFile(ByteBuffer bytes) {
        if (this.tempFile == null) {
            this.useTempFile();
        }
        try {
            this.tempFileWriteChannel.write(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void expandTo(long requestedSize) {
        int currentCapacity = this.buffer.capacity();
        int maxBufferSize = CONF.getBufferLimitSizeKb() * 1024;
        int newSize = requestedSize > (long)(currentCapacity * 2) ? (int)requestedSize : currentCapacity * 2;
        newSize = maxBufferSize > newSize ? newSize : maxBufferSize;
        this.buffer = ByteBuffer.allocate(newSize).put((ByteBuffer)this.buffer.flip());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        block7: {
            String string;
            if (this.contentPath != null) {
                return "Content-Path: " + this.contentPath.toString();
            }
            if (this.input != null) {
                return this.peek(this.input);
            }
            if (this.tempFile == null) break block7;
            BufferedInputStream istream = new BufferedInputStream(new FileInputStream(this.tempFile));
            try {
                string = this.peek(istream);
            }
            catch (Throwable throwable) {
                try {
                    FileUtil.closeQuietly((Closeable[])new Closeable[]{istream});
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            FileUtil.closeQuietly((Closeable[])new Closeable[]{istream});
            return string;
        }
        return new StringBuilder(this.buffer == null ? CharBuffer.allocate(0) : this.response.getCharset().decode((ByteBuffer)this.buffer.duplicate().flip())).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String peek(InputStream input) throws IOException {
        if (!input.markSupported()) {
            return "InputStream: " + input.getClass().getName();
        }
        byte[] peeked = new byte[16384];
        input.mark(16384);
        int readSize = 0;
        try {
            readSize = input.read(peeked);
        }
        finally {
            input.reset();
        }
        return new StringBuilder(this.response.getCharset().decode(ByteBuffer.wrap(peeked, 0, readSize))).append(readSize == 16384 ? "..." : "").toString();
    }

    public InputStream getInputStream() {
        if (this.contentPath != null) {
            try {
                return this.contentPath.getInputStream();
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        if (this.input != null) {
            return this.input;
        }
        if (this.tempFile != null) {
            try {
                return new FileInputStream(this.tempFile);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.buffer == null) {
            this.buffer = ByteBuffer.wrap(new byte[0]);
        }
        return new InputStreamWrapper((ByteBuffer)this.buffer.flip());
    }

    public ResponseBody setInputStream(InputStream input) {
        this.input = input;
        STREAM_HOLDER.get().add(input);
        return this;
    }

    public static void addTempFileToDelete(File file) {
        TEMP_FILE_HOLDER.get().add(file);
    }

    public static void cleanup() {
        Collection<Closeable> streams = STREAM_HOLDER.get();
        for (Closeable stream : streams) {
            FileUtil.closeQuietly((Closeable[])new Closeable[]{stream});
        }
        Collection<File> tempFiles = TEMP_FILE_HOLDER.get();
        for (File file : tempFiles) {
            if (file.delete()) continue;
            LOGGER.logWarn("could not delete a temporary file: " + file.getAbsolutePath(), new Object[0]);
        }
        streams.clear();
        tempFiles.clear();
    }

    private void useTempFile() {
        File dir = this.getDownloadDir();
        try {
            this.tempFile = File.createTempFile("nablarch_temp_", null, dir);
            this.tempFileWriteChannel = new FileOutputStream(this.tempFile).getChannel();
            TEMP_FILE_HOLDER.get().add(this.tempFile);
            STREAM_HOLDER.get().add(this.tempFileWriteChannel);
            this.tempFileWriteChannel.write((ByteBuffer)this.buffer.flip());
            this.buffer = null;
        }
        catch (IOException e) {
            throw new RuntimeException("download temp file create failed. ", e);
        }
    }

    private File getDownloadDir() {
        String tempDirRootPath = CONF.getTempDirPath();
        if (tempDirRootPath == null) {
            return null;
        }
        File file = new File(tempDirRootPath);
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("failed to create download dir.  file=[" + file.toString() + "]");
        }
        return file;
    }

    private static class InputStreamWrapper
    extends InputStream {
        private final ByteBuffer buffer;

        public InputStreamWrapper(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public synchronized int read() throws IOException {
            if (!this.buffer.hasRemaining()) {
                return -1;
            }
            return this.buffer.get();
        }

        @Override
        public synchronized int read(byte[] bytes, int off, int len) throws IOException {
            if (!this.buffer.hasRemaining()) {
                return -1;
            }
            len = Math.min(len, this.buffer.remaining());
            this.buffer.get(bytes, off, len);
            return len;
        }
    }
}

