/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.download.encorder;

import java.util.ArrayList;
import java.util.List;
import nablarch.core.util.annotation.Published;
import nablarch.fw.web.download.encorder.DownloadFileNameEncoder;
import nablarch.fw.web.download.encorder.DownloadFileNameEncoderEntry;
import nablarch.fw.web.download.encorder.MimeBDownloadFileNameEncoder;
import nablarch.fw.web.download.encorder.UrlDownloadFileNameEncoder;

@Published(tag={"architect"})
public class DownloadFileNameEncoderFactory {
    private DownloadFileNameEncoder defaultEncoder = new UrlDownloadFileNameEncoder();
    private List<DownloadFileNameEncoderEntry> downloadFileNameEncoderEntries = this.createDownloadFileNameEncoderEntries();

    protected ArrayList<DownloadFileNameEncoderEntry> createDownloadFileNameEncoderEntries() {
        ArrayList<DownloadFileNameEncoderEntry> list = new ArrayList<DownloadFileNameEncoderEntry>();
        list.add(this.createEntry(".*MSIE.*", new UrlDownloadFileNameEncoder()));
        list.add(this.createEntry(".*Trident.*", new UrlDownloadFileNameEncoder()));
        list.add(this.createEntry(".*WebKit.*", new UrlDownloadFileNameEncoder()));
        list.add(this.createEntry(".*Gecko.*", new MimeBDownloadFileNameEncoder()));
        return list;
    }

    private DownloadFileNameEncoderEntry createEntry(String userAgentPattern, DownloadFileNameEncoder encoder) {
        DownloadFileNameEncoderEntry entry = new DownloadFileNameEncoderEntry();
        entry.setUserAgentPattern(userAgentPattern);
        entry.setEncoder(encoder);
        return entry;
    }

    public void setDefaultEncoder(DownloadFileNameEncoder defaultEncoder) {
        this.defaultEncoder = defaultEncoder;
    }

    public void setDownloadFileNameEncoderEntries(List<DownloadFileNameEncoderEntry> downloadFileNameEncoderEntries) {
        for (DownloadFileNameEncoderEntry entry : downloadFileNameEncoderEntries) {
            if (entry.getUserAgentPattern() != null) continue;
            throw new RuntimeException("userAgentPattern property was not configured.");
        }
        this.downloadFileNameEncoderEntries = downloadFileNameEncoderEntries;
    }

    public DownloadFileNameEncoder getEncoder(String userAgent) {
        if (userAgent == null) {
            return this.defaultEncoder;
        }
        for (DownloadFileNameEncoderEntry entry : this.downloadFileNameEncoderEntries) {
            if (!entry.getUserAgentPattern().matcher(userAgent).matches()) continue;
            return entry.getEncoder();
        }
        return this.defaultEncoder;
    }
}

