/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.handler;

import java.util.Map;
import nablarch.core.log.LogUtil;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.log.app.AppLogUtil;
import nablarch.core.util.ObjectUtil;
import nablarch.fw.Request;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.handler.HttpAccessLogFormatter;
import nablarch.fw.web.servlet.ServletExecutionContext;

public final class HttpAccessLogUtil {
    private static final Logger HTTP_ACCESS_LOGGER = LoggerManager.get((String)"HTTP_ACCESS");
    private static final String PROPS_CLASS_NAME = "httpAccessLogFormatter.className";
    private static final LogUtil.ObjectCreator<HttpAccessLogFormatter> HTTP_ACCESS_LOG_FORMATTER_CREATOR = new LogUtil.ObjectCreator<HttpAccessLogFormatter>(){

        public HttpAccessLogFormatter create() {
            HttpAccessLogFormatter formatter = null;
            Map props = AppLogUtil.getProps();
            if (props.containsKey(HttpAccessLogUtil.PROPS_CLASS_NAME)) {
                String className = (String)props.get(HttpAccessLogUtil.PROPS_CLASS_NAME);
                formatter = (HttpAccessLogFormatter)ObjectUtil.createInstance((String)className);
            } else {
                formatter = new HttpAccessLogFormatter();
            }
            return formatter;
        }
    };
    private static final String KEY_HTTP_ACCESS_LOG_CONTEXT = "nablarch_httpAccessLogContext";

    private HttpAccessLogUtil() {
    }

    public static void initialize() {
        HttpAccessLogUtil.getAccessLogFormatter();
    }

    public static HttpAccessLogFormatter.HttpAccessLogContext getAccessLogContext(Request<?> request, ServletExecutionContext context) {
        Map<String, Object> requestScope = context.getRequestScopeMap();
        if (requestScope.containsKey(KEY_HTTP_ACCESS_LOG_CONTEXT)) {
            return (HttpAccessLogFormatter.HttpAccessLogContext)requestScope.get(KEY_HTTP_ACCESS_LOG_CONTEXT);
        }
        HttpAccessLogFormatter.HttpAccessLogContext logContext = HttpAccessLogUtil.getAccessLogFormatter().createAccessLogContext();
        requestScope.put(KEY_HTTP_ACCESS_LOG_CONTEXT, logContext);
        logContext.setContext(context);
        logContext.setRequest((HttpRequest)request);
        return logContext;
    }

    private static HttpAccessLogFormatter getAccessLogFormatter() {
        return (HttpAccessLogFormatter)LogUtil.getObjectBoundToClassLoader(HTTP_ACCESS_LOG_FORMATTER_CREATOR);
    }

    public static boolean containsMemoryItem() {
        return HttpAccessLogUtil.getAccessLogFormatter().containsMemoryItem();
    }

    public static void begin(HttpAccessLogFormatter.HttpAccessLogContext context, Object[] logOptions) {
        HttpAccessLogFormatter formatter = HttpAccessLogUtil.getAccessLogFormatter();
        if (formatter.isBeginOutputEnabled()) {
            HTTP_ACCESS_LOGGER.logInfo(HttpAccessLogUtil.getAccessLogFormatter().formatBegin(context), logOptions);
        }
    }

    public static void logParameters(HttpAccessLogFormatter.HttpAccessLogContext context) {
        HttpAccessLogFormatter formatter = HttpAccessLogUtil.getAccessLogFormatter();
        if (formatter.isParametersOutputEnabled()) {
            HTTP_ACCESS_LOGGER.logInfo(formatter.formatParameters(context), new Object[0]);
        }
    }

    public static void logDispatchingClass(HttpAccessLogFormatter.HttpAccessLogContext context) {
        HttpAccessLogFormatter formatter = HttpAccessLogUtil.getAccessLogFormatter();
        if (formatter.isDispatchingClassOutputEnabled()) {
            HTTP_ACCESS_LOGGER.logInfo(HttpAccessLogUtil.getAccessLogFormatter().formatDispatchingClass(context), new Object[0]);
        }
    }

    public static void end(HttpAccessLogFormatter.HttpAccessLogContext context, Object[] logOptions) {
        HttpAccessLogFormatter formatter = HttpAccessLogUtil.getAccessLogFormatter();
        if (formatter.isEndOutputEnabled()) {
            HTTP_ACCESS_LOGGER.logInfo(HttpAccessLogUtil.getAccessLogFormatter().formatEnd(context), logOptions);
        }
    }
}

