/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.handler;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Request;
import nablarch.fw.handler.JavaPackageMappingEntry;
import nablarch.fw.handler.RequestPathJavaPackageMapping;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpRequestHandler;
import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.handler.HttpAccessLogFormatter;
import nablarch.fw.web.handler.HttpAccessLogUtil;
import nablarch.fw.web.servlet.ServletExecutionContext;

public class HttpRequestJavaPackageMapping
implements HttpRequestHandler {
    private final Mapping mapping;

    @Override
    public HttpResponse handle(HttpRequest request, ExecutionContext context) {
        return (HttpResponse)this.mapping.handle(request, context);
    }

    public HttpRequestJavaPackageMapping() {
        this.mapping = new Mapping();
    }

    public HttpRequestJavaPackageMapping(String baseUri, String basePackage) {
        this.mapping = new Mapping(baseUri, basePackage);
    }

    public HttpRequestJavaPackageMapping setBasePath(String basePath) {
        return this.setBaseUri(basePath);
    }

    public HttpRequestJavaPackageMapping setBaseUri(String baseUri) {
        try {
            if (baseUri != null) {
                baseUri = new URI(baseUri).toASCIIString();
            }
            this.mapping.setBasePath(baseUri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("invalid requestPath: " + baseUri, e);
        }
        return this;
    }

    public HttpRequestJavaPackageMapping setBasePackage(String basePackage) {
        this.mapping.setBasePackage(basePackage);
        return this;
    }

    public HttpRequestJavaPackageMapping setOptionalPackageMappingEntries(List<JavaPackageMappingEntry> optionalPackageMappingEntries) {
        this.mapping.setOptionalPackageMappingEntries(optionalPackageMappingEntries);
        return this;
    }

    public static class Mapping
    extends RequestPathJavaPackageMapping {
        public Mapping() {
        }

        public Mapping(String basePath, String basePackage) {
            super(basePath, basePackage);
        }

        protected void writeDispatchingClassLog(Request<?> req, ExecutionContext ctx, String fqn) {
            if (ctx instanceof ServletExecutionContext) {
                ServletExecutionContext context = (ServletExecutionContext)ctx;
                HttpAccessLogFormatter.HttpAccessLogContext logContext = HttpAccessLogUtil.getAccessLogContext(req, context);
                logContext.setDispatchingClass(fqn);
                HttpAccessLogUtil.logDispatchingClass(logContext);
            }
        }
    }
}

