/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.handler;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nablarch.common.web.session.SessionUtil;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.util.Builder;
import nablarch.core.util.FileUtil;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Handler;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.ResourceLocator;
import nablarch.fw.web.download.encorder.DownloadFileNameEncoder;
import nablarch.fw.web.download.encorder.DownloadFileNameEncoderFactory;
import nablarch.fw.web.handler.HttpResponseUtil;
import nablarch.fw.web.i18n.DirectoryBasedResourcePathRule;
import nablarch.fw.web.i18n.ResourcePathRule;
import nablarch.fw.web.servlet.NablarchHttpServletRequestWrapper;
import nablarch.fw.web.servlet.ServletExecutionContext;

public class HttpResponseHandler
implements Handler<HttpRequest, HttpResponse> {
    private static final Logger LOGGER = LoggerManager.get(HttpResponseHandler.class);
    protected static final String USER_AGENT = "User-Agent";
    private boolean usesFlush = true;
    private HttpResponseUtil.StatusConvertMode convertMode = HttpResponseUtil.StatusConvertMode.CONVERT_ONLY_400_TO_200;
    private DownloadFileNameEncoderFactory downloadFileNameEncoderFactory = new DownloadFileNameEncoderFactory();
    private static final int BUFFER_SIZE = 4096;
    private ResourcePathRule contentPathRule = new DirectoryBasedResourcePathRule();
    private final String fatalErrorMessage = Builder.linesf((Object[])new Object[]{"<html>", "  <head>", "    <title>A system error occurred.</title>", "  </head>", "  <body>", "    <p>", "      We are sorry not to be able to proceed your request.<br/>", "      Please contact the system administrator of our system.", "    </p>", "  </body>", "</html>"});

    public void setForceFlushAfterWritingHeaders(boolean usesFlush) {
        this.usesFlush = usesFlush;
    }

    public HttpResponseHandler setDownloadFileNameEncoderFactory(DownloadFileNameEncoderFactory factory) {
        this.downloadFileNameEncoderFactory = factory;
        return this;
    }

    public void setConvertMode(String convertMode) {
        this.convertMode = HttpResponseUtil.StatusConvertMode.valueOf(convertMode);
    }

    /*
     * Exception decompiling
     */
    public HttpResponse handle(HttpRequest req, ExecutionContext ctx) throws ClassCastException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isClientDisconnected(ServletException e) {
        Throwable t = e;
        while ((t = t.getCause()) != null) {
            if (!t.getClass().isAssignableFrom(SocketException.class)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeResponse(HttpResponse res, ServletExecutionContext ctx) {
        try {
            if (res.isBodyEmpty() && this.isErrorResponse(res)) {
                ctx.getServletResponse().sendError(res.getStatusCode());
            } else {
                InputStream bodyStream = res.getBodyStream();
                if (bodyStream == null) {
                    bodyStream = this.getFatalErrorResponse().getBodyStream();
                }
                this.writeHeaders(res, ctx);
                HttpResponseHandler.writeBody(bodyStream, ctx.getServletResponse());
            }
        }
        catch (IOException e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.logWarn("Uncaught error: ", (Throwable)e, new Object[0]);
            }
        }
        finally {
            res.cleanup();
        }
    }

    protected boolean isErrorResponse(HttpResponse res) {
        int statusCode = res.getStatusCode();
        return statusCode < 200 || statusCode >= 400;
    }

    private boolean doesServletForward(HttpResponse res) {
        return res.getContentPath() != null && res.getContentPath().getScheme().equals("servlet");
    }

    private boolean doesRedirect(HttpResponse res) {
        ResourceLocator path = res.getContentPath();
        return path != null && path.isRedirect();
    }

    private void doServletForward(HttpResponse res, ServletExecutionContext ctx) throws ServletException, IOException {
        HttpResponseHandler.setStatusCode(res, ctx);
        this.setHeaders(res, ctx);
        String pathToForward = this.getPathForLanguage(res, ctx);
        if (this.isSessionExportRequired(pathToForward)) {
            this.exportSessionStore(ctx);
        }
        ctx.getServletRequest().getRequestDispatcher(pathToForward).forward((ServletRequest)ctx.getServletRequest(), (ServletResponse)ctx.getServletResponse());
    }

    private void exportSessionStore(ServletExecutionContext ctx) {
        Map<String, Object> requestScope = ctx.getRequestScopeMap();
        for (String key : ctx.getSessionStoreMap().keySet()) {
            Object sessionStored;
            if (requestScope.containsKey(key) || (sessionStored = SessionUtil.orNull(ctx, key)) == null) continue;
            requestScope.put(key, sessionStored);
        }
    }

    private boolean isSessionExportRequired(String pathToForward) {
        return pathToForward != null && pathToForward.contains(".");
    }

    private void doRedirect(HttpResponse res, ServletExecutionContext ctx) throws IOException {
        this.setHeaders(res, ctx);
        ResourceLocator path = res.getContentPath();
        String to = path.getScheme().matches("https?") ? path.toString() : (path.isRelative() ? path.getPath() : ctx.getServletContext().getContextPath() + path.getPath());
        HttpServletResponse servletResponse = ctx.getServletResponse();
        to = servletResponse.encodeRedirectURL(to);
        servletResponse.sendRedirect(to);
    }

    private String getPathForLanguage(HttpResponse res, ServletExecutionContext ctx) {
        String path = res.getContentPath().getPath();
        NablarchHttpServletRequestWrapper req = ctx.getServletRequest();
        return this.contentPathRule.getPathForLanguage(path, (HttpServletRequest)req);
    }

    public void setContentPathRule(ResourcePathRule contentPathRule) {
        this.contentPathRule = contentPathRule;
    }

    private void writeHeaders(HttpResponse res, ServletExecutionContext ctx) throws IOException {
        ctx.getServletResponse().setStatus(res.getStatusCode());
        this.setHeaders(res, ctx);
        if (this.usesFlush) {
            ctx.getServletResponse().flushBuffer();
        }
    }

    protected static void setStatusCode(HttpResponse res, ServletExecutionContext ctx) {
        HttpServletResponse servletRes = ctx.getServletResponse();
        int statusCode = HttpResponseUtil.chooseResponseStatusCode(res, ctx);
        servletRes.setStatus(statusCode);
    }

    private void setHeaders(HttpResponse res, ServletExecutionContext ctx) {
        ctx.getServletResponse().setContentType(res.getContentType());
        for (Map.Entry<String, String> header : res.getHeaderMap().entrySet()) {
            String key = header.getKey();
            String val = header.getValue();
            if ("Content-Length".equals(key)) continue;
            if ("Content-Disposition".equals(key)) {
                val = this.replaceContentDisposition(val, (HttpServletRequest)ctx.getServletRequest());
            }
            ctx.getServletResponse().setHeader(key, val);
        }
        for (Cookie cookie : res.getCookieList()) {
            ctx.getServletResponse().addCookie(cookie);
        }
    }

    private String replaceContentDisposition(String dispositionValue, HttpServletRequest nativeReq) {
        Pattern pattern = Pattern.compile("(.*filename=\")(.*)(\".*)");
        Matcher matcher = pattern.matcher(dispositionValue);
        if (!matcher.matches()) {
            return dispositionValue;
        }
        String userAgent = nativeReq.getHeader(USER_AGENT);
        DownloadFileNameEncoder encoder = this.downloadFileNameEncoderFactory.getEncoder(userAgent);
        String encodedFileName = encoder.encode(matcher.group(2));
        return matcher.replaceFirst("$1" + encodedFileName + "$3");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBody(InputStream in, HttpServletResponse nativeRes) throws IOException {
        ServletOutputStream out = nativeRes.getOutputStream();
        try {
            byte[] bytes;
            int readBytes;
            while ((readBytes = in.read(bytes = new byte[4096])) != -1) {
                out.write(bytes, 0, readBytes);
            }
        }
        catch (Throwable throwable) {
            FileUtil.closeQuietly((Closeable[])new Closeable[]{in});
            FileUtil.closeQuietly((Closeable[])new Closeable[]{out});
            throw throwable;
        }
        FileUtil.closeQuietly((Closeable[])new Closeable[]{in});
        FileUtil.closeQuietly((Closeable[])new Closeable[]{out});
    }

    private HttpResponse getFatalErrorResponse() {
        return new HttpResponse(500).setContentType("text/html;charset=UTF-8").setBodyStream(new ByteArrayInputStream(this.fatalErrorMessage.getBytes()));
    }
}

