/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.handler;

import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.servlet.ServletExecutionContext;

public final class HttpResponseUtil {
    private static final String HTTP_STATUS_CONVERT_MODE_KEY = "nablarch_http_status_convert_mode";

    private HttpResponseUtil() {
    }

    public static int chooseResponseStatusCode(HttpResponse res, ServletExecutionContext ctx) {
        int statusCode = HttpResponseUtil.isAjaxRequest(ctx) ? res.getStatusCode() : (ctx.getRequestScopedVar(HTTP_STATUS_CONVERT_MODE_KEY) == StatusConvertMode.CONVERT_ALL_TO_200 ? (res != null && 300 <= res.getStatusCode() && res.getStatusCode() <= 399 ? res.getStatusCode() : 200) : (res == null || 400 == res.getStatusCode() ? 200 : res.getStatusCode()));
        return statusCode;
    }

    public static boolean isAjaxRequest(ServletExecutionContext ctx) {
        return "XMLHttpRequest".equals(ctx.getServletRequest().getHeader("X-Requested-With"));
    }

    public static void setStatusConvertMode(ServletExecutionContext ctx, StatusConvertMode mode) {
        ctx.setRequestScopedVar(HTTP_STATUS_CONVERT_MODE_KEY, (Object)mode);
    }

    public static enum StatusConvertMode {
        CONVERT_ALL_TO_200,
        CONVERT_ONLY_400_TO_200;

    }
}

