/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.handler;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.fw.ExecutionContext;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpRequestHandler;
import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.ResourceLocator;

public class ResourceMapping
implements HttpRequestHandler {
    private String baseUri;
    private String scheme;
    private String basePath;
    private static final Logger LOGGER = LoggerManager.get(ResourceMapping.class);

    public ResourceMapping(String baseUri, String basePath) {
        this.setBaseUri(baseUri);
        this.setBasePath(basePath);
    }

    public ResourceMapping() {
        this.baseUri = null;
        this.basePath = null;
    }

    public ResourceMapping setBaseUri(String baseUri) {
        try {
            this.baseUri = new URI(baseUri).toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("invalid requestPath: " + baseUri, e);
        }
        return this;
    }

    public ResourceMapping setBasePath(String basePath) {
        ResourceLocator locator;
        try {
            locator = ResourceLocator.valueOf(basePath);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid path: " + basePath, e);
        }
        this.scheme = locator.getScheme();
        if (this.scheme.equals("file")) {
            throw new IllegalArgumentException("Invalid scheme: " + this.scheme);
        }
        try {
            this.basePath = locator.getPath();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid path: " + basePath, e);
        }
        return this;
    }

    @Override
    public HttpResponse handle(HttpRequest req, ExecutionContext ctx) {
        if (this.baseUri == null || this.basePath == null) {
            throw new IllegalStateException("baseUri and basePath must be set.");
        }
        if (!req.getRequestUri().startsWith(this.baseUri)) {
            return HttpResponse.Status.NOT_FOUND.handle(req, ctx);
        }
        String relPath = req.getRequestPath().replaceFirst("^" + Pattern.quote(this.baseUri), "");
        String contentPath = this.scheme + "://" + (this.basePath + relPath).replaceAll("//+", "/");
        LOGGER.logInfo("this request mapped to the resource path of '" + contentPath + "'", new Object[0]);
        ResourceLocator resource = ResourceLocator.valueOf(contentPath);
        if (!resource.exists()) {
            return HttpResponse.Status.NOT_FOUND.handle(req, ctx);
        }
        return new HttpResponse().setStatusCode(200).setContentPath(resource);
    }
}

