/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.handler;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import nablarch.fw.ExecutionContext;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpRequestHandler;
import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.handler.secure.ContentTypeOptionsHeader;
import nablarch.fw.web.handler.secure.FrameOptionsHeader;
import nablarch.fw.web.handler.secure.SecureResponseHeader;
import nablarch.fw.web.handler.secure.XssProtectionHeader;
import nablarch.fw.web.servlet.ServletExecutionContext;

public class SecureHandler
implements HttpRequestHandler {
    private List<? extends SecureResponseHeader> secureResponseHeaderList = Arrays.asList(new FrameOptionsHeader(), new XssProtectionHeader(), new ContentTypeOptionsHeader());

    @Override
    public HttpResponse handle(HttpRequest request, ExecutionContext context) {
        HttpResponse response = (HttpResponse)context.handleNext((Object)request);
        ServletExecutionContext servletExecutionContext = (ServletExecutionContext)context;
        for (SecureResponseHeader secureResponseHeader : this.secureResponseHeaderList) {
            if (!secureResponseHeader.isOutput(response, servletExecutionContext)) continue;
            response.setHeader(secureResponseHeader.getName(), secureResponseHeader.getValue());
        }
        return response;
    }

    public void setSecureResponseHeaderList(List<? extends SecureResponseHeader> secureResponseHeaderList) {
        this.secureResponseHeaderList = Collections.unmodifiableList(secureResponseHeaderList);
    }
}

