/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.handler;

import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.message.ApplicationException;
import nablarch.core.message.Message;
import nablarch.core.message.MessageLevel;
import nablarch.core.message.MessageUtil;
import nablarch.core.util.StringUtil;
import nablarch.core.util.annotation.Published;
import nablarch.core.util.map.CopyOnReadMap;
import nablarch.core.util.map.LockableMap;
import nablarch.core.util.map.MapWrapper;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Handler;
import nablarch.fw.results.Conflicted;
import nablarch.fw.web.HttpResponse;

@Deprecated
public class SessionConcurrentAccessHandler
implements Handler<Object, Object> {
    private ConcurrentAccessPolicy concurrentAccessPolicy = ConcurrentAccessPolicy.CONCURRENT;
    private String conflictWarningMessageId = null;
    private static final ThreadLocal<Boolean> THROWS_ON_SESSION_WRITE_CONFLICT = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private static final Logger LOGGER = LoggerManager.get(SessionConcurrentAccessHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handle(Object req, ExecutionContext ctx) {
        SessionConcurrentAccessHandler.setThrowsErrorOnSessionWriteConflict(false);
        CopyOnReadMap wrappedSession = null;
        Map session = ctx.getSessionScopeMap();
        wrappedSession = new CopyOnReadMap(new LockableMap(session)).setIgnoredEntries("/nablarch_session_token");
        HttpResponse res = null;
        try {
            ctx.setSessionScopeMap(wrappedSession);
            res = (HttpResponse)ctx.handleNext(req);
        }
        finally {
            try {
                ((CopyOnReadMap)((Object)wrappedSession.getDelegateMapOfType(CopyOnReadMap.class))).save();
            }
            catch (ConcurrentModificationException e) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.logInfo("Could not apply modification of session scope variables because another concurrent thread has already applied its modification.", (Throwable)e, new Object[0]);
                }
                this.manageSessionRWConfliction(ctx, e);
            }
            catch (CopyOnReadMap.SnapshotCreationError e) {
                throw new IllegalStateException("Could not apply modification of session scope variables because could not take snapshot of current session scope.", e);
            }
            catch (IllegalStateException e) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.logInfo("Could not apply modification of session scope variables because the session scope is in invalid state.", (Throwable)e, new Object[0]);
                }
                this.manageSessionRWConfliction(ctx, e);
            }
            LockableMap lockable = (LockableMap)wrappedSession.getDelegateMapOfType(LockableMap.class);
            if (lockable != null) {
                lockable.deactivate();
            }
        }
        return res;
    }

    private void manageSessionRWConfliction(ExecutionContext ctx, RuntimeException e) {
        Message message = null;
        if (!StringUtil.isNullOrEmpty((String)this.conflictWarningMessageId)) {
            message = MessageUtil.createMessage((MessageLevel)MessageLevel.ERROR, (String)this.conflictWarningMessageId, (Object[])new Object[0]);
            ApplicationException ae = new ApplicationException(message);
            ctx.setException((Throwable)ae);
        }
        if (THROWS_ON_SESSION_WRITE_CONFLICT.get().booleanValue()) {
            throw new SessionConfliction(message == null ? "your request was failed due to a session access confliction with another concurrent request." : message.formatMessage());
        }
    }

    public SessionConcurrentAccessHandler setConcurrentAccessPolicy(String policyName) throws IllegalArgumentException {
        this.concurrentAccessPolicy = Enum.valueOf(ConcurrentAccessPolicy.class, policyName);
        return this;
    }

    public ConcurrentAccessPolicy getConcurrentAccessPolicy() {
        return this.concurrentAccessPolicy == null ? ConcurrentAccessPolicy.CONCURRENT : this.concurrentAccessPolicy;
    }

    public void setConflictWarningMessageId(String messageId) {
        this.conflictWarningMessageId = messageId;
    }

    public static void lockSession(Map<String, Object> session) {
        SessionConcurrentAccessHandler.getSessionLock(session).lock();
    }

    public static void unlockSession(Map<String, Object> session) {
        SessionConcurrentAccessHandler.getSessionLock(session).unlock();
    }

    private static Lock getSessionLock(Map<String, Object> session) {
        return (Lock)((MapWrapper)session).getDelegateMapOfType(Lock.class);
    }

    public static void setThrowsErrorOnSessionWriteConflict(boolean throwsError) {
        THROWS_ON_SESSION_WRITE_CONFLICT.set(throwsError);
    }

    @Published(tag={"architect"})
    public static class SessionConfliction
    extends Conflicted {
        public SessionConfliction(String message) {
            super(message);
        }
    }

    public static enum ConcurrentAccessPolicy {
        CONCURRENT;

    }
}

