/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.i18n;

import java.net.MalformedURLException;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import nablarch.core.ThreadContext;
import nablarch.core.util.annotation.Published;
import nablarch.fw.web.i18n.BasicServletContextCreator;
import nablarch.fw.web.i18n.ServletContextCreator;
import nablarch.fw.web.servlet.UriUtil;

@Published(tag={"architect"})
public abstract class ResourcePathRule {
    private ServletContextCreator servletContextCreator = new BasicServletContextCreator();

    public void setServletContextCreator(ServletContextCreator servletContextCreator) {
        this.servletContextCreator = servletContextCreator;
    }

    public String getPathForLanguage(String path, HttpServletRequest request) {
        Locale locale = ThreadContext.getLanguage();
        if (locale == null) {
            return path;
        }
        int extensionIndex = path.lastIndexOf(46);
        if (extensionIndex == -1) {
            return path;
        }
        String pathFromContextRoot = this.convertToPathFromContextRoot(path, request);
        String pathForLanguage = this.createPathForLanguage(pathFromContextRoot, locale.getLanguage());
        if (!this.existsResource(pathForLanguage, request)) {
            return path;
        }
        String addedPath = pathFromContextRoot.replace(path, "");
        if (!addedPath.isEmpty()) {
            pathForLanguage = pathForLanguage.substring(addedPath.length());
        }
        return pathForLanguage;
    }

    protected boolean existsResource(String resourcePath, HttpServletRequest request) {
        try {
            return this.getServletContext(request).getResource(resourcePath) != null;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private ServletContext getServletContext(HttpServletRequest request) {
        return this.servletContextCreator.create(request);
    }

    protected String convertToPathFromContextRoot(String path, HttpServletRequest request) {
        return UriUtil.convertToPathFromContextRoot(path, request);
    }

    protected abstract String createPathForLanguage(String var1, String var2);
}

