/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.interceptor;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import nablarch.core.util.annotation.Published;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Interceptor;
import nablarch.fw.web.HttpErrorResponse;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.interceptor.OnError;

@Documented
@Target(value={ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@Interceptor(value=Impl.class)
@Published
public @interface OnErrors {
    public OnError[] value();

    public static class Impl
    extends Interceptor.Impl<HttpRequest, HttpResponse, OnErrors> {
        public HttpResponse handle(HttpRequest request, ExecutionContext context) {
            try {
                return (HttpResponse)this.getOriginalHandler().handle((Object)request, context);
            }
            catch (RuntimeException e) {
                for (OnError onError : ((OnErrors)this.getInterceptor()).value()) {
                    if (!onError.type().isAssignableFrom(e.getClass())) continue;
                    throw new HttpErrorResponse(onError.statusCode(), onError.path(), e);
                }
                throw e;
            }
        }
    }
}

