/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.post;

import java.util.Collections;
import java.util.Map;
import nablarch.core.ThreadContext;
import nablarch.core.util.StringUtil;
import nablarch.fw.ExecutionContext;
import nablarch.fw.web.HttpErrorResponse;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpRequestHandler;
import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.post.PostRequest;

@Deprecated
public class PostResubmitPreventHandler
implements HttpRequestHandler {
    public static final String POST_RESUBMIT_PREVENT_PARAM = "nablarch_post_resubmit_prevent";
    private static final String POST_REDIRECT_ID_PARAM = "nablarch_post_redirect_id";
    private static final String POST_REQUEST_KEY_PREFIX = "nablarch_post_request_";
    private Map<String, String> forwardPathMapping = Collections.emptyMap();

    @Override
    public HttpResponse handle(HttpRequest request, ExecutionContext context) {
        if (this.isPostRedirect(request)) {
            context.setSessionScopedVar(this.generatePostRequestKey(ThreadContext.getExecutionId()), (Object)this.createPostRequest(request));
            return new HttpResponse(this.generateRedirectPath(request));
        }
        if (this.isRedirectOnPost(request)) {
            PostRequest postRequest = this.getPostRequest(request, context);
            if (postRequest == null) {
                throw new HttpErrorResponse(400, this.getForwardPath(ThreadContext.getRequestId()));
            }
            request.setParamMap(postRequest.getParamMap());
        }
        return (HttpResponse)context.handleNext((Object)request);
    }

    private String getForwardPath(String requestId) {
        String path = null;
        int length = 0;
        for (Map.Entry<String, String> entry : this.forwardPathMapping.entrySet()) {
            int keyLength;
            if (!requestId.startsWith(entry.getKey()) || length >= (keyLength = entry.getKey().length())) continue;
            length = keyLength;
            path = entry.getValue();
        }
        if (path == null) {
            throw new IllegalArgumentException("forward path not found in path mapping. request id=[" + requestId + ']');
        }
        return path;
    }

    protected boolean isPostRedirect(HttpRequest request) {
        return "post".equals(request.getMethod().toLowerCase()) && request.getParamMap().containsKey(POST_RESUBMIT_PREVENT_PARAM);
    }

    protected PostRequest createPostRequest(HttpRequest request) {
        return new PostRequest(request);
    }

    protected String generatePostRequestKey(String executionId) {
        return POST_REQUEST_KEY_PREFIX + executionId;
    }

    protected String generateRedirectPath(HttpRequest request) {
        return "redirect://" + request.getRequestUri() + "?" + POST_REDIRECT_ID_PARAM + "=" + ThreadContext.getExecutionId();
    }

    protected boolean isRedirectOnPost(HttpRequest request) {
        return request.getParamMap().containsKey(POST_REDIRECT_ID_PARAM);
    }

    protected PostRequest getPostRequest(HttpRequest request, ExecutionContext context) {
        String[] postRedirectId = request.getParamMap().remove(POST_REDIRECT_ID_PARAM);
        if (StringUtil.isNullOrEmpty((String[])postRedirectId)) {
            return null;
        }
        return (PostRequest)context.getSessionScopeMap().remove(this.generatePostRequestKey(postRedirectId[0]));
    }

    public void setForwardPathMapping(Map<String, String> forwardPathMapping) {
        this.forwardPathMapping = Collections.unmodifiableMap(forwardPathMapping);
    }
}

