/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.servlet;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.util.annotation.Published;
import nablarch.core.util.map.CaseInsensitiveMap;
import nablarch.core.util.map.EnumerableIterator;
import nablarch.fw.results.BadRequest;
import nablarch.fw.web.servlet.RequestAttributeMap;
import nablarch.fw.web.servlet.SessionAttributeMap;

public class NablarchHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private final HttpServletRequest origReq;
    private Map<String, Object> scope;
    private HttpSessionWrapper sessionWrapper = null;
    private Map<String, String> headerMap;
    private static final String POST_PARAM_READ_ERROR_MESSAGE = "Could not read the post parameters due to improperly formatted message body or some network problems.";
    private Map<String, String[]> paramMap;
    private static final Logger LOGGER = LoggerManager.get(NablarchHttpServletRequestWrapper.class);

    public NablarchHttpServletRequestWrapper(HttpServletRequest delegate) {
        super(delegate);
        this.origReq = delegate;
        this.scope = new RequestAttributeMap(delegate);
        this.createHeaderMap();
    }

    public Map<String, String> getHeaderMap() {
        return this.headerMap;
    }

    public NablarchHttpServletRequestWrapper setHeaderMap(Map<String, String> headerMap) {
        this.headerMap = headerMap;
        return this;
    }

    public NablarchHttpServletRequestWrapper setParamMap(Map<String, String[]> params) {
        this.paramMap = params;
        return this;
    }

    public Map<String, Object> getScope() {
        return this.scope;
    }

    public NablarchHttpServletRequestWrapper setScope(Map<String, Object> scope) {
        this.scope = scope;
        return this;
    }

    @Published(tag={"architect"})
    public HttpSessionWrapper getSession() {
        return this.getSession(true);
    }

    @Published(tag={"architect"})
    public HttpSessionWrapper getSession(boolean create) {
        HttpSession session = this.origReq.getSession(false);
        if (session == null) {
            if (create) {
                this.sessionWrapper = new HttpSessionWrapper(this.origReq.getSession(true));
                return this.sessionWrapper;
            }
            return null;
        }
        if (this.sessionWrapper == null) {
            this.sessionWrapper = new HttpSessionWrapper(session);
        }
        return this.sessionWrapper;
    }

    @Published(tag={"architect"})
    public String getHeader(String name) {
        return this.headerMap.get(name);
    }

    public Enumeration<String> getHeaderNames() {
        return new EnumerableIterator<String>(this.headerMap.keySet().iterator());
    }

    private void createHeaderMap() {
        this.headerMap = new CaseInsensitiveMap();
        Enumeration headerNames = this.origReq.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String headerValue = this.origReq.getHeader(headerName);
            this.headerMap.put(headerName, headerValue);
        }
    }

    public String getParameter(String name) {
        String[] values = this.getParameterMap().get(name);
        return values == null || values.length == 0 ? super.getParameter(name) : values[0];
    }

    public Map<String, String[]> getParameterMap() {
        if (this.paramMap == null) {
            this.createParamMap();
        }
        return this.paramMap;
    }

    public Enumeration<String> getParameterNames() {
        return new EnumerableIterator<String>(this.getParameterMap().keySet().iterator());
    }

    public String[] getParameterValues(String name) {
        return this.getParameterMap().get(name);
    }

    private void createParamMap() {
        this.paramMap = new HashMap<String, String[]>();
        Map postParams = null;
        try {
            postParams = this.origReq.getParameterMap();
        }
        catch (Exception e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.logWarn(POST_PARAM_READ_ERROR_MESSAGE, (Throwable)e, new Object[0]);
            }
            throw new PostParameterReadError(POST_PARAM_READ_ERROR_MESSAGE, e);
        }
        this.paramMap.putAll(postParams);
    }

    public ServletRequest getRequest() {
        return this.origReq;
    }

    public static class HttpSessionWrapper
    implements HttpSession {
        private final HttpSession delegate;
        private Map<String, Object> scope;

        public HttpSessionWrapper(HttpSession delegate) {
            this.delegate = delegate;
            this.scope = new SessionAttributeMap(delegate);
        }

        public Map<String, Object> getScope() {
            return this.scope;
        }

        public HttpSessionWrapper setScope(Map<String, Object> scope) {
            this.scope = scope;
            return this;
        }

        public Object getAttribute(String name) {
            return this.scope.get(name);
        }

        public Enumeration<String> getAttributeNames() {
            return new EnumerableIterator<String>(this.scope.keySet().iterator());
        }

        public void setAttribute(String name, Object value) {
            this.scope.put(name, value);
        }

        public void removeAttribute(String name) {
            this.scope.remove(name);
        }

        public Object getValue(String name) {
            return this.getAttribute(name);
        }

        public String[] getValueNames() {
            return this.scope.keySet().toArray(new String[0]);
        }

        public void putValue(String name, Object value) {
            this.setAttribute(name, value);
        }

        public void removeValue(String name) {
            this.removeAttribute(name);
        }

        public long getCreationTime() {
            return this.delegate.getCreationTime();
        }

        @Published(tag={"architect"})
        public String getId() {
            return this.delegate.getId();
        }

        public long getLastAccessedTime() {
            return this.delegate.getLastAccessedTime();
        }

        public int getMaxInactiveInterval() {
            return this.delegate.getMaxInactiveInterval();
        }

        public ServletContext getServletContext() {
            return this.delegate.getServletContext();
        }

        public HttpSessionContext getSessionContext() {
            return this.delegate.getSessionContext();
        }

        public void invalidate() {
            this.delegate.invalidate();
        }

        public boolean isNew() {
            return this.delegate.isNew();
        }

        public void setMaxInactiveInterval(int interval) {
            this.delegate.setMaxInactiveInterval(interval);
        }

        public HttpSession getDelegate() {
            return this.delegate;
        }
    }

    @Published(tag={"architect"})
    public static class PostParameterReadError
    extends BadRequest {
        public PostParameterReadError(String message, Throwable e) {
            super(message, e);
        }
    }
}

