/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.servlet;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.log.app.FailureLogUtil;
import nablarch.core.log.app.LogInitializationHelper;
import nablarch.core.log.app.PerformanceLogUtil;
import nablarch.core.repository.ObjectLoader;
import nablarch.core.repository.SystemRepository;
import nablarch.core.repository.di.ComponentDefinitionLoader;
import nablarch.core.repository.di.DiContainer;
import nablarch.core.repository.di.config.DuplicateDefinitionPolicy;
import nablarch.core.repository.di.config.xml.XmlComponentDefinitionLoader;
import nablarch.fw.web.handler.HttpAccessLogUtil;

public class NablarchServletContextListener
implements ServletContextListener {
    private static final Logger LOGGER = LoggerManager.get(NablarchServletContextListener.class);
    private static final String DI_CONTAINER_CONFIG_FILE_KEY = "di.config";
    private static final String DI_CONTAINER_DUPLICATE_DEFINITION_CONFIG_KEY = "di.duplicate-definition-policy";

    public void contextInitialized(ServletContextEvent event) {
        try {
            this.initializeLog();
            if (!this.isRequestTest()) {
                this.initializeRepository(event);
            }
            LOGGER.logInfo("[" + NablarchServletContextListener.class.getName() + "#contextInitialized] initialization completed.", new Object[0]);
        }
        catch (RuntimeException e) {
            FailureLogUtil.logFatal((Throwable)e, (Object)null, null, (Object[])new Object[0]);
            throw e;
        }
    }

    private void initializeRepository(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        String configFile = servletContext.getInitParameter(DI_CONTAINER_CONFIG_FILE_KEY);
        String duplicateDefinitionPolicy = servletContext.getInitParameter(DI_CONTAINER_DUPLICATE_DEFINITION_CONFIG_KEY);
        DuplicateDefinitionPolicy policy = this.evaluateDuplicateDefinitionPolicy(duplicateDefinitionPolicy);
        XmlComponentDefinitionLoader loader = new XmlComponentDefinitionLoader(configFile, policy);
        DiContainer container = new DiContainer((ComponentDefinitionLoader)loader);
        SystemRepository.load((ObjectLoader)container);
    }

    private DuplicateDefinitionPolicy evaluateDuplicateDefinitionPolicy(String stringExpression) {
        if (stringExpression == null) {
            return DuplicateDefinitionPolicy.OVERRIDE;
        }
        try {
            return DuplicateDefinitionPolicy.valueOf((String)stringExpression);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Illegal duplicate definition policy was specified.di.duplicate-definition-policy = " + stringExpression, e);
        }
    }

    private boolean isRequestTest() {
        Object o = SystemRepository.get((String)"httpTestConfiguration");
        return o != null;
    }

    private void initializeLog() {
        FailureLogUtil.initialize();
        PerformanceLogUtil.initialize();
        HttpAccessLogUtil.initialize();
        LogInitializationHelper.initialize();
    }

    public void contextDestroyed(ServletContextEvent event) {
        LOGGER.logInfo("[" + NablarchServletContextListener.class.getName() + "#contextDestroyed]", new Object[0]);
        LoggerManager.terminate();
    }
}

