/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.servlet;

import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nablarch.core.util.annotation.Published;
import nablarch.fw.ExecutionContext;
import nablarch.fw.web.HttpMethodBinding;
import nablarch.fw.web.servlet.HttpRequestWrapper;
import nablarch.fw.web.servlet.NablarchHttpServletRequestWrapper;

public class ServletExecutionContext
extends ExecutionContext {
    private final NablarchHttpServletRequestWrapper servletReq;
    private final HttpServletResponse servletRes;
    private final ServletContext servletCtx;
    private final HttpRequestWrapper request;

    public ServletExecutionContext(HttpServletRequest servletReq, HttpServletResponse servletRes, ServletContext servletCtx) {
        this.servletReq = new NablarchHttpServletRequestWrapper(servletReq);
        this.servletRes = servletRes;
        this.servletCtx = servletCtx;
        this.setMethodBinder(new HttpMethodBinding.Binder());
        this.request = new HttpRequestWrapper(this.servletReq);
    }

    public HttpRequestWrapper getHttpRequest() {
        return this.request;
    }

    @Published(tag={"architect"})
    public NablarchHttpServletRequestWrapper getServletRequest() {
        return this.servletReq;
    }

    @Published(tag={"architect"})
    public HttpServletResponse getServletResponse() {
        return this.servletRes;
    }

    public ServletContext getServletContext() {
        return this.servletCtx;
    }

    public ExecutionContext invalidateSession() {
        NablarchHttpServletRequestWrapper.HttpSessionWrapper session = this.servletReq.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        return this;
    }

    public boolean isNewSession() {
        return this.servletReq.getSession(true).isNew();
    }

    public boolean hasSession() {
        return this.servletReq.getSession(false) != null;
    }

    public Map<String, Object> getRequestScopeMap() {
        return this.servletReq.getScope();
    }

    public ExecutionContext setRequestScopeMap(Map<String, Object> scope) {
        this.servletReq.setScope(scope);
        return this;
    }

    public Map<String, Object> getSessionScopeMap() {
        return this.servletReq.getSession().getScope();
    }

    public <T> T getSessionScopedVar(String varName) throws ClassCastException {
        if (!this.hasSession()) {
            return null;
        }
        return (T)super.getSessionScopedVar(varName);
    }

    public ExecutionContext setSessionScopeMap(Map<String, Object> scope) {
        this.servletReq.getSession().setScope(scope);
        return this;
    }

    public HttpSession getNativeHttpSession(boolean create) {
        NablarchHttpServletRequestWrapper.HttpSessionWrapper wrapper = this.servletReq.getSession(create);
        return wrapper == null ? null : wrapper.getDelegate();
    }
}

