/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.upload;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.servlet.ServletInputStream;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.util.StringUtil;
import nablarch.fw.results.BadRequest;
import nablarch.fw.results.RequestEntityTooLarge;
import nablarch.fw.web.upload.MultipartContext;

class MultipartInputStream {
    private static final Logger LOG = LoggerManager.get(MultipartInputStream.class);
    private static final int EOS = -1;
    private final ServletInputStream in;
    private final MultipartContext ctx;
    private final int limit;
    private int readCount = 0;
    private byte[] cache;
    private int count;
    private int pos;
    private boolean eof;
    private String boundary;

    MultipartInputStream(ServletInputStream in, MultipartContext ctx, int limit) {
        this.in = in;
        this.ctx = ctx;
        this.limit = limit;
    }

    String readLine() throws IOException {
        int readBytes;
        int bufferSize = 4096;
        int limitSize = 10240;
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        byte[] buf = new byte[4096];
        do {
            try {
                readBytes = this.in.readLine(buf, 0, buf.length);
            }
            catch (IOException e) {
                LOG.logWarn("incomplete upload data.", (Throwable)e, new Object[0]);
                throw new BadRequest("incomplete uploading", (Throwable)e);
            }
            if (readBytes == -1) continue;
            this.addReadCount(readBytes);
            out.write(buf, 0, readBytes);
        } while (readBytes == buf.length && out.size() <= 10240);
        if (out.size() == 0) {
            return null;
        }
        if (out.size() > 10240) {
            throw new BadRequest("header record size is too large. header record size = [" + out.size() + ']');
        }
        String line = new String(out.toByteArray(), this.ctx.getRequestCharacterEncoding());
        line = StringUtil.chomp((String)line, (String)"\n");
        line = StringUtil.chomp((String)line, (String)"\r");
        return line;
    }

    void skipTillBoundary(String boundary) throws IOException {
        String line;
        do {
            if ((line = this.readLine()) != null) continue;
            throw new BadRequest("no data found.");
        } while (!line.startsWith(boundary));
        this.boundary = boundary;
    }

    int read(byte[] pbuf) throws IOException {
        int readBytesNum;
        int rest = this.countRestLength();
        if (rest <= 0) {
            this.fill();
            rest = this.countRestLength();
            if (rest <= 0) {
                return -1;
            }
        }
        int transferredBytesNum = Math.min(pbuf.length, rest);
        System.arraycopy(this.cache, this.pos, pbuf, 0, transferredBytesNum);
        this.pos += transferredBytesNum;
        for (readBytesNum = transferredBytesNum; readBytesNum < pbuf.length; readBytesNum += transferredBytesNum) {
            this.fill();
            rest = this.countRestLength();
            if (rest <= 0) {
                return readBytesNum;
            }
            transferredBytesNum = Math.min(pbuf.length - readBytesNum, rest);
            System.arraycopy(this.cache, this.pos, pbuf, readBytesNum, transferredBytesNum);
            this.pos += transferredBytesNum;
        }
        return readBytesNum;
    }

    String readParam() throws IOException {
        int readBytes;
        ByteArrayOutputStream out = new ByteArrayOutputStream(512);
        byte[] buf256 = new byte[256];
        while ((readBytes = this.read(buf256)) != -1) {
            out.write(buf256, 0, readBytes);
        }
        return out.toString(this.ctx.getRequestCharacterEncoding());
    }

    private int countRestLength() {
        return this.count - this.pos - 2;
    }

    private void fill() throws IOException {
        if (this.eof) {
            return;
        }
        if (this.count > 0) {
            if (this.count - this.pos == 2) {
                System.arraycopy(this.cache, this.pos, this.cache, 0, 2);
                this.count = 2;
                this.pos = 0;
            } else {
                throw new BadRequest("incomplete uploading.");
            }
        }
        int read = 0;
        int boundaryLength = this.boundary.length();
        int maxRead = this.cache.length - boundaryLength - 2;
        while (this.count < maxRead) {
            try {
                read = this.in.readLine(this.cache, this.count, this.cache.length - this.count);
            }
            catch (IOException e) {
                LOG.logWarn("incomplete upload data.", (Throwable)e, new Object[0]);
                throw new BadRequest("incomplete uploading", (Throwable)e);
            }
            if (read == -1) {
                throw new BadRequest("input stream unexpectedly ended before boundary appears.");
            }
            this.addReadCount(read);
            if (read >= boundaryLength) {
                this.eof = true;
                for (int i = 0; i < boundaryLength; ++i) {
                    if (this.boundary.charAt(i) == this.cache[this.count + i]) continue;
                    this.eof = false;
                    break;
                }
                if (this.eof) break;
            }
            this.count += read;
        }
    }

    private void addReadCount(int count) throws RequestEntityTooLarge {
        this.readCount += count;
        if (this.readCount > this.limit) {
            this.consume();
            throw new RequestEntityTooLarge();
        }
    }

    void consume() {
        try {
            while (this.in.skip(0x100000L) > 0L) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void reset() {
        this.cache = new byte[65536];
        this.count = 0;
        this.pos = 0;
        this.eof = false;
    }
}

