/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.upload;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.util.map.MapWrapper;
import nablarch.fw.web.upload.PartInfo;

public class PartInfoHolder
extends MapWrapper<String, List<PartInfo>> {
    private static final Logger LOGGER = LoggerManager.get(PartInfoHolder.class);
    private static final PartInfoHolder EMPTY_INSTANCE = new PartInfoHolder(Collections.<String, List<PartInfo>>emptyMap());
    private final Map<String, List<PartInfo>> delegate;

    public PartInfoHolder() {
        this(new HashMap<String, List<PartInfo>>());
    }

    PartInfoHolder(Map<String, List<PartInfo>> baseMap) {
        this.delegate = baseMap;
    }

    static PartInfoHolder getEmptyInstance() {
        return EMPTY_INSTANCE;
    }

    public void addPart(PartInfo part) {
        this.addPart(part.getName(), part);
    }

    void addPart(String name, PartInfo part) {
        if (this.containsKey(name)) {
            ((List)this.get(name)).add(part);
        } else {
            ArrayList<PartInfo> list = new ArrayList<PartInfo>();
            list.add(part);
            this.put(name, list);
        }
    }

    void cleanup() {
        for (List list : this.values()) {
            for (PartInfo e : list) {
                e.clean();
            }
        }
    }

    void logAllPart() {
        if (!LOGGER.isInfoEnabled()) {
            return;
        }
        ArrayList<String> logMessages = new ArrayList<String>();
        for (List list : this.values()) {
            for (PartInfo part : list) {
                logMessages.add(part.toString());
            }
        }
        LOGGER.logInfo(logMessages.size() + " file(s) uploaded.", new Object[0]);
        for (String msg : logMessages) {
            LOGGER.logInfo("\t" + msg, new Object[0]);
        }
    }

    public Map<String, List<PartInfo>> getDelegateMap() {
        return this.delegate;
    }
}

