/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.upload;

import java.io.File;
import java.net.URL;
import nablarch.core.util.FilePathSetting;

public class UploadSettings {
    static final String UPLOAD_FILE_TMP_DIR = "uploadFileTmpDir";
    private static final File DEFAULT_SAVE_DIR = new File(System.getProperty("java.io.tmpdir"));
    private int contentLengthLimit = Integer.MAX_VALUE;
    private boolean autoCleaning = true;

    File getSaveDir() {
        FilePathSetting filePathSetting = FilePathSetting.getInstance();
        URL saveDir = (URL)filePathSetting.getBasePathSettings().get(UPLOAD_FILE_TMP_DIR);
        return saveDir == null ? DEFAULT_SAVE_DIR : new File(saveDir.getFile());
    }

    public int getContentLengthLimit() {
        return this.contentLengthLimit;
    }

    public void setContentLengthLimit(int contentLengthLimit) {
        if (contentLengthLimit < 0) {
            throw new IllegalArgumentException("contentLengthLimit must not be negative.");
        }
        this.contentLengthLimit = contentLengthLimit;
    }

    public boolean isAutoCleaning() {
        return this.autoCleaning;
    }

    public void setAutoCleaning(boolean autoCleaning) {
        this.autoCleaning = autoCleaning;
    }
}

