/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.testing.lessio;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.nesscomputing.testing.lessio.AllowAll;
import com.nesscomputing.testing.lessio.AllowDNSResolution;
import com.nesscomputing.testing.lessio.AllowExternalProcess;
import com.nesscomputing.testing.lessio.AllowLocalFileAccess;
import com.nesscomputing.testing.lessio.AllowNetworkAccess;
import com.nesscomputing.testing.lessio.AllowNetworkListen;
import com.nesscomputing.testing.lessio.AllowNetworkMulticast;
import java.io.FileDescriptor;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URLClassLoader;
import java.security.Permission;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.internal.runners.statements.InvokeMethod;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.rules.TestRule;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LessIOSecurityManager
extends SecurityManager {
    protected static final String JAVA_HOME = System.getProperty("java.home");
    protected static final String PATH_SEPARATOR = System.getProperty("path.separator");
    protected static final AtomicReference<List<String>> CP_PARTS = new AtomicReference<ImmutableList<String>>(LessIOSecurityManager.getClassPath());
    protected static final String TMP_DIR = System.getProperty("java.io.tmpdir").replaceFirst("/$", "");
    private static final Set<Class<?>> whitelistedClasses = ImmutableSet.of(ClassLoader.class, URLClassLoader.class);
    private static final Set<Class<?>> TESTRUNNER_CLASSES;
    private static final Set<String> LOCAL_HOSTS;
    private final int lowestEphemeralPort = Integer.getInteger("ness.testing.low-ephemeral-port", Integer.getInteger("kawala.testing.low-ephemeral-port", 32768));
    private final int highestEphemeralPort = Integer.getInteger("ness.testing.high-ephemeral-port", Integer.getInteger("kawala.testing.high-ephemeral-port", 65535));
    private final Set<Integer> allocatedEphemeralPorts = Sets.newSetFromMap((Map)Maps.newConcurrentMap());
    private final boolean reporting = Boolean.getBoolean("ness.testing.security-manager.reporting");

    protected Set<Class<?>> getWhitelistedClasses() {
        return whitelistedClasses;
    }

    private static ImmutableList<String> getClassPath() {
        return ImmutableList.copyOf((Object[])System.getProperty("java.class.path").split(PATH_SEPARATOR));
    }

    private static boolean hasAnnotations(Class<?> clazz, Class<?> ... annotations) {
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"clazz argument can not be null!");
        Preconditions.checkArgument((annotations != null && annotations.length > 0 ? 1 : 0) != 0, (Object)"at least one annotation must be present");
        for (Class<?> currentClazz = clazz; currentClazz != null; currentClazz = currentClazz.getSuperclass()) {
            Class<?> enclosingClass = currentClazz.getEnclosingClass();
            for (Class<?> annotation : annotations) {
                if (currentClazz.getAnnotation(annotation) != null) {
                    return true;
                }
                while (enclosingClass != null) {
                    if (enclosingClass.getAnnotation(annotation) != null) {
                        return true;
                    }
                    enclosingClass = enclosingClass.getEnclosingClass();
                }
            }
        }
        return false;
    }

    private static <T> T findAnnotation(Class<?> clazz, Class<T> annotation) {
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"clazz argument can not be null!");
        Preconditions.checkArgument((annotation != null ? 1 : 0) != 0, (Object)"annotation must be present");
        for (Class<?> currentClazz = clazz; currentClazz != null; currentClazz = currentClazz.getSuperclass()) {
            T a = currentClazz.getAnnotation(annotation);
            if (a != null) {
                return a;
            }
            for (Class<?> enclosingClass = currentClazz.getEnclosingClass(); enclosingClass != null; enclosingClass = enclosingClass.getEnclosingClass()) {
                a = enclosingClass.getAnnotation(annotation);
                if (a == null) continue;
                return a;
            }
        }
        return null;
    }

    private static boolean isTestrunnerClass(Class<?> clazz) {
        for (Class<?> currentClazz = clazz; currentClazz != null; currentClazz = currentClazz.getSuperclass()) {
            Class<?>[] interfaces;
            if (TESTRUNNER_CLASSES.contains(currentClazz)) {
                return true;
            }
            for (Class<?> enclosingClass = currentClazz.getEnclosingClass(); enclosingClass != null; enclosingClass = enclosingClass.getEnclosingClass()) {
                if (LessIOSecurityManager.isTestrunnerClass(enclosingClass)) {
                    return true;
                }
                for (Class<?> interfaceClass : interfaces = enclosingClass.getInterfaces()) {
                    if (!LessIOSecurityManager.isTestrunnerClass(interfaceClass)) continue;
                    return true;
                }
            }
            for (Class<?> interfaceClass : interfaces = currentClazz.getInterfaces()) {
                if (!LessIOSecurityManager.isTestrunnerClass(interfaceClass)) continue;
                return true;
            }
        }
        return false;
    }

    protected void checkDNSResolution(Class<?>[] classContext, String host) throws CantDoItException {
        if (LOCAL_HOSTS.contains(host)) {
            return;
        }
        if (this.traceWithoutExplicitlyAllowedClass(classContext)) {
            this.checkClassContextPermissions(classContext, new Predicate<Class<?>>(){

                public boolean apply(Class<?> input) {
                    return LessIOSecurityManager.hasAnnotations(input, new Class[]{AllowDNSResolution.class, AllowNetworkMulticast.class, AllowNetworkListen.class, AllowNetworkAccess.class});
                }

                public String toString() {
                    return String.format("@AllowDNSResolution permission", new Object[0]);
                }
            });
        }
    }

    protected void checkNetworkEndpoint(final String host, final int port, final String description) throws CantDoItException {
        Class<?>[] classContext = this.getClassContext();
        if (port == -1) {
            this.checkDNSResolution(classContext, host);
            return;
        }
        if (this.traceWithoutExplicitlyAllowedClass(classContext)) {
            this.checkClassContextPermissions(classContext, new Predicate<Class<?>>(){

                public boolean apply(Class<?> input) {
                    String[] endpoints = null;
                    AllowNetworkAccess access = (AllowNetworkAccess)LessIOSecurityManager.findAnnotation(input, AllowNetworkAccess.class);
                    if (access != null) {
                        endpoints = access.endpoints();
                    }
                    if (endpoints == null) {
                        return false;
                    }
                    for (String endpoint : endpoints) {
                        String[] parts = endpoint.split(":");
                        String portAsString = Integer.toString(port);
                        if (!(parts[0].equals(host) && parts[1].equals(portAsString) || parts[0].equals("*") && parts[1].equals(portAsString) || parts[0].equals(host) && parts[1].equals("*")) && (!parts[0].equals(host) || !parts[1].equals("0") || !LessIOSecurityManager.this.allocatedEphemeralPorts.contains(port))) continue;
                        return true;
                    }
                    return false;
                }

                public String toString() {
                    return String.format("@AllowNetworkAccess permission for %s:%d (%s)", host, port, description);
                }
            });
        }
    }

    @Override
    public void checkAccept(String host, int port) throws CantDoItException {
        this.checkNetworkEndpoint(host, port, "accept");
    }

    @Override
    public void checkConnect(String host, int port, Object context) throws CantDoItException {
        this.checkNetworkEndpoint(host, port, "connect");
    }

    @Override
    public void checkConnect(String host, int port) throws CantDoItException {
        this.checkNetworkEndpoint(host, port, "connect");
    }

    @Override
    public void checkListen(final int port) throws CantDoItException {
        Class<?>[] classContext = this.getClassContext();
        if (this.traceWithoutExplicitlyAllowedClass(classContext)) {
            this.checkClassContextPermissions(classContext, new Predicate<Class<?>>(){

                public boolean apply(Class<?> input) {
                    int[] ports = null;
                    AllowNetworkListen a = (AllowNetworkListen)LessIOSecurityManager.findAnnotation(input, AllowNetworkListen.class);
                    if (a != null) {
                        ports = a.ports();
                    }
                    if (ports == null) {
                        return false;
                    }
                    for (int p : ports) {
                        if (p == 0 && port >= LessIOSecurityManager.this.lowestEphemeralPort && port <= LessIOSecurityManager.this.highestEphemeralPort) {
                            p = port;
                            LessIOSecurityManager.this.allocatedEphemeralPorts.add(port);
                        }
                        if (p != port) continue;
                        return true;
                    }
                    return false;
                }

                public String toString() {
                    return String.format("@AllowNetworkListen permission for port %d", port);
                }
            });
        }
    }

    @Override
    public void checkMulticast(InetAddress maddr) throws CantDoItException {
        Class<?>[] classContext = this.getClassContext();
        if (this.traceWithoutExplicitlyAllowedClass(classContext)) {
            this.checkClassContextPermissions(classContext, new Predicate<Class<?>>(){

                public boolean apply(Class<?> input) {
                    return LessIOSecurityManager.hasAnnotations(input, new Class[]{AllowNetworkMulticast.class});
                }

                public String toString() {
                    return String.format("@AllowNetworkMulticast permission", new Object[0]);
                }
            });
        }
    }

    @Override
    public void checkMulticast(InetAddress maddr, byte ttl) throws CantDoItException {
        this.checkMulticast(maddr);
    }

    protected void checkFileAccess(final String file, final String description) throws CantDoItException {
        Class<?>[] classContext = this.getClassContext();
        if (this.traceWithoutExplicitlyAllowedClass(classContext)) {
            if (file.startsWith(JAVA_HOME)) {
                return;
            }
            if (file.startsWith("/dev/random") || file.startsWith("/dev/urandom") || file.startsWith("/tmp/junit")) {
                return;
            }
            for (String part : CP_PARTS.get()) {
                if (!file.startsWith(part)) continue;
                return;
            }
            this.checkClassContextPermissions(classContext, new Predicate<Class<?>>(){

                public boolean apply(Class<?> input) {
                    String[] paths = null;
                    AllowLocalFileAccess a = (AllowLocalFileAccess)LessIOSecurityManager.findAnnotation(input, AllowLocalFileAccess.class);
                    if (a != null) {
                        paths = a.paths();
                    }
                    if (paths == null) {
                        return false;
                    }
                    for (String p : paths) {
                        if (!(p.equals("*") || p.equals(file) || p.contains("%TMP_DIR%") && file.startsWith(p.replaceAll("%TMP_DIR%", TMP_DIR)) || p.startsWith("*") && p.endsWith("*") && file.contains(p.split("\\*")[1]) || p.startsWith("*") && file.endsWith(p.replaceFirst("^\\*", ""))) && (!p.endsWith("*") || !file.startsWith(p.replaceFirst("\\*$", "")))) continue;
                        return true;
                    }
                    return false;
                }

                public String toString() {
                    return String.format("@AllowLocalFileAccess for %s (%s)", file, description);
                }
            });
        }
    }

    public void checkFileDescriptorAccess(final FileDescriptor fd, final String description) throws CantDoItException {
        Class<?>[] classContext = this.getClassContext();
        if (this.traceWithoutExplicitlyAllowedClass(classContext)) {
            this.checkClassContextPermissions(classContext, new Predicate<Class<?>>(){

                public boolean apply(Class<?> input) {
                    if (LessIOSecurityManager.hasAnnotations(input, new Class[]{AllowExternalProcess.class, AllowNetworkAccess.class})) {
                        return true;
                    }
                    String[] paths = null;
                    AllowLocalFileAccess a = (AllowLocalFileAccess)LessIOSecurityManager.findAnnotation(input, AllowLocalFileAccess.class);
                    if (a != null) {
                        paths = a.paths();
                    }
                    if (paths == null) {
                        return false;
                    }
                    for (String p : paths) {
                        if (!p.equals("%FD%")) continue;
                        return true;
                    }
                    return false;
                }

                public String toString() {
                    return String.format("@AllowLocalFileAccess for FileDescriptor(%s) (%s)", fd, description);
                }
            });
        }
    }

    @Override
    public void checkRead(String file, Object context) {
        this.checkFileAccess(file, "read");
    }

    @Override
    public void checkRead(String file) {
        this.checkRead(file, null);
    }

    @Override
    public void checkRead(FileDescriptor fd) {
        this.checkFileDescriptorAccess(fd, "read");
    }

    @Override
    public void checkDelete(String file) {
        this.checkFileAccess(file, "delete");
    }

    @Override
    public void checkWrite(FileDescriptor fd) {
        this.checkFileDescriptorAccess(fd, "write");
    }

    @Override
    public void checkWrite(String file) {
        this.checkFileAccess(file, "write");
    }

    @Override
    public void checkExec(final String cmd) throws CantDoItException {
        Class<?>[] classContext = this.getClassContext();
        if (this.traceWithoutExplicitlyAllowedClass(classContext)) {
            this.checkClassContextPermissions(classContext, new Predicate<Class<?>>(){

                public boolean apply(Class<?> input) {
                    return LessIOSecurityManager.hasAnnotations(input, new Class[]{AllowExternalProcess.class});
                }

                public String toString() {
                    return String.format("@AllowExternalProcess for %s (exec)", cmd);
                }
            });
        }
    }

    @Override
    public void checkExit(int status) {
        if (this.reporting) {
            LogHolder.LOG.debug("%s: exit(%d)", (Object)this.currentTest(this.getClassContext()), (Object)status);
        }
    }

    @Override
    public void checkLink(String lib) {
        if (this.reporting) {
            LogHolder.LOG.debug("%s: System.loadLibrary(\"%s\")", (Object)this.currentTest(this.getClassContext()), (Object)lib);
        }
    }

    public void checkAwtEventQueueAccess() {
        if (this.reporting) {
            LogHolder.LOG.debug("%s: AwtEventQueue Access", (Object)this.currentTest(this.getClassContext()));
        }
    }

    @Override
    public void checkPrintJobAccess() {
        if (this.reporting) {
            LogHolder.LOG.debug("%s: PrintJob Access", (Object)this.currentTest(this.getClassContext()));
        }
    }

    public void checkSystemClipboardAccess() {
        if (this.reporting) {
            LogHolder.LOG.debug("%s: SystemClipboard Access", (Object)this.currentTest(this.getClassContext()));
        }
    }

    public boolean checkTopLevelWindow(Object window) {
        if (this.reporting) {
            LogHolder.LOG.debug("%s: checkTopLevelWindow aka AWTPermission(\"showWindowWithoutWarningBanner\")", (Object)this.currentTest(this.getClassContext()));
        }
        return true;
    }

    @Override
    public void checkAccess(Thread t) {
    }

    @Override
    public void checkAccess(ThreadGroup g) {
    }

    public void checkMemberAccess(Class<?> clazz, int which) {
    }

    @Override
    public void checkPackageAccess(String pkg) {
    }

    @Override
    public void checkPackageDefinition(String pkg) {
    }

    @Override
    public void checkSetFactory() {
    }

    @Override
    public void checkCreateClassLoader() {
        CP_PARTS.set((List<String>)LessIOSecurityManager.getClassPath());
    }

    @Override
    public void checkPropertiesAccess() {
    }

    @Override
    public void checkPropertyAccess(String key) {
    }

    @Override
    public void checkSecurityAccess(String target) {
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
    }

    @Override
    public void checkPermission(Permission perm) {
    }

    private boolean isClassWhitelisted(Class<?> clazz) {
        if (this.getWhitelistedClasses().contains(clazz)) {
            return true;
        }
        for (Class<?> enclosingClass = clazz.getEnclosingClass(); enclosingClass != null; enclosingClass = enclosingClass.getEnclosingClass()) {
            if (!this.isClassWhitelisted(enclosingClass)) continue;
            return true;
        }
        return false;
    }

    private boolean traceWithoutExplicitlyAllowedClass(Class<?>[] classContext) {
        for (Class<?> clazz : classContext) {
            if (this.isClassWhitelisted(clazz)) {
                return false;
            }
            if (!LessIOSecurityManager.isTestrunnerClass(clazz) || !LessIOSecurityManager.hasAnnotations(clazz, AllowAll.class)) continue;
            return false;
        }
        return true;
    }

    private void checkClassContextPermissions(Class<?>[] classContext, Predicate<Class<?>> classAuthorized) throws CantDoItException {
        boolean encounteredTestMethodRunner = false;
        boolean failed = false;
        for (Class<?> clazz : classContext) {
            if (LessIOSecurityManager.isTestrunnerClass(clazz)) {
                encounteredTestMethodRunner = true;
            } else if (LessIOSecurityManager.hasAnnotations(clazz, AllowAll.class)) {
                LogHolder.LOG.error("Found @AllowAll on a non-testrunner class (%s), refusing to run test!", (Object)clazz.getName());
                failed = true;
                break;
            }
            if (!classAuthorized.apply(clazz)) continue;
            return;
        }
        if (!failed && !encounteredTestMethodRunner) {
            if (this.reporting) {
                LogHolder.LOG.debug("No test runner encountered, assuming a non-test context");
            }
            return;
        }
        CantDoItException e = new CantDoItException(String.format("No class in the class context satisfies %s", classAuthorized));
        if (this.reporting) {
            StackTraceElement testClassStackFrame = this.currentTest(classContext);
            String testName = "unknown test";
            if (testClassStackFrame != null) {
                testName = String.format("%s.%s():%d", testClassStackFrame.getClassName(), testClassStackFrame.getMethodName(), testClassStackFrame.getLineNumber());
            }
            LogHolder.LOG.error("%s: No %s at %s", new Object[]{testName, classAuthorized, testName});
            for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
                LogHolder.LOG.trace("%s: Stack: %s.%s():%d", new Object[]{testName, stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getLineNumber()});
            }
            for (Serializable serializable : classContext) {
                LogHolder.LOG.trace("%s: Class Context: %s %s", new Object[]{testName, ((Class)serializable).getCanonicalName(), serializable});
            }
        }
        throw e;
    }

    public StackTraceElement currentTest(Class<?>[] classContext) {
        Class<?> testClass = null;
        for (Class<?> clazz : classContext) {
            if (LessIOSecurityManager.isTestrunnerClass(clazz)) break;
            testClass = clazz;
        }
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement testClassStackFrame = null;
        for (StackTraceElement el : stackTrace) {
            if (!el.getClassName().equals(testClass.getCanonicalName())) continue;
            testClassStackFrame = el;
        }
        return testClassStackFrame;
    }

    static {
        LOCAL_HOSTS = ImmutableSet.of((Object)"localhost", (Object)"127.0.0.1", (Object)"::1");
        Set testrunnerClasses = Sets.newIdentityHashSet();
        testrunnerClasses.add(ParentRunner.class);
        testrunnerClasses.add(RunAfters.class);
        testrunnerClasses.add(RunBefores.class);
        testrunnerClasses.add(FrameworkMethod.class);
        testrunnerClasses.add(InvokeMethod.class);
        testrunnerClasses.add(TestRule.class);
        testrunnerClasses.add(Statement.class);
        TESTRUNNER_CLASSES = Collections.unmodifiableSet(testrunnerClasses);
    }

    public static class CantDoItException
    extends RuntimeException {
        private static final long serialVersionUID = -8858380898538847118L;

        public CantDoItException() {
        }

        public CantDoItException(String s) {
            super(s);
        }

        public CantDoItException(String s, CantDoItException e) {
            super(s, e);
        }
    }

    private static class LogHolder {
        private static final Logger LOG = LoggerFactory.getLogger(LessIOSecurityManager.class);

        private LogHolder() {
        }
    }
}

