/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.netflix.config.ConcurrentCompositeConfiguration;
import com.netflix.config.ConfigurationBackedDynamicPropertySupportImpl;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicDoubleProperty;
import com.netflix.config.DynamicFloatProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicLongProperty;
import com.netflix.config.DynamicProperty;
import com.netflix.config.DynamicPropertySupport;
import com.netflix.config.DynamicStringProperty;
import com.netflix.config.DynamicURLConfiguration;
import com.netflix.config.ExpandedConfigurationListenerAdapter;
import com.netflix.config.MissingConfigurationSourceException;
import com.netflix.config.PropertyWrapper;
import com.netflix.config.jmx.ConfigJMXManager;
import com.netflix.config.jmx.ConfigMBean;
import java.util.Collection;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicPropertyFactory {
    private static DynamicPropertyFactory instance = new DynamicPropertyFactory();
    private static volatile DynamicPropertySupport config = null;
    private static volatile boolean initializedWithDefaultConfig = false;
    private static volatile boolean defaultConfigNotFound = false;
    private static final Logger logger = LoggerFactory.getLogger(DynamicPropertyFactory.class);
    public static final String URL_CONFIG_NAME = "archaius.dynamicPropertyFactory.URL_CONFIG";
    public static final String SYS_CONFIG_NAME = "archaius.dynamicPropertyFactory.SYS_CONFIG";
    public static final String ENABLE_JMX = "archaius.dynamicPropertyFactory.registerConfigWithJMX";
    private static ConfigMBean configMBean = null;
    public static final String THROW_MISSING_CONFIGURATION_SOURCE_EXCEPTION = "archaius.dynamicProperty.throwMissingConfigurationSourceException";
    private static volatile boolean throwMissingConfigurationSourceException = Boolean.getBoolean("archaius.dynamicProperty.throwMissingConfigurationSourceException");
    public static final String DISABLE_DEFAULT_SYS_CONFIG = "archaius.dynamicProperty.disableSystemConfig";
    public static final String DISABLE_DEFAULT_CONFIG = "archaius.dynamicProperty.disableDefaultConfig";

    private DynamicPropertyFactory() {
    }

    public static synchronized DynamicPropertyFactory initWithConfigurationSource(AbstractConfiguration abstractConfiguration) {
        if (abstractConfiguration instanceof DynamicPropertySupport) {
            return DynamicPropertyFactory.initWithConfigurationSource((DynamicPropertySupport)abstractConfiguration);
        }
        if (Boolean.getBoolean(ENABLE_JMX)) {
            try {
                configMBean = ConfigJMXManager.registerConfigMbean(abstractConfiguration);
            }
            catch (Exception exception) {
                logger.error("Unable to register with JMX", (Throwable)exception);
            }
        }
        return DynamicPropertyFactory.initWithConfigurationSource(new ConfigurationBackedDynamicPropertySupportImpl(abstractConfiguration));
    }

    public static boolean isInitializedWithDefaultConfig() {
        return initializedWithDefaultConfig;
    }

    public static Object getBackingConfigurationSource() {
        if (config instanceof ConfigurationBackedDynamicPropertySupportImpl) {
            return ((ConfigurationBackedDynamicPropertySupportImpl)config).getConfiguration();
        }
        return config;
    }

    public static void setThrowMissingConfigurationSourceException(boolean bl) {
        throwMissingConfigurationSourceException = bl;
    }

    public static boolean isThrowMissingConfigurationSourceException() {
        return throwMissingConfigurationSourceException;
    }

    public static synchronized DynamicPropertyFactory initWithConfigurationSource(DynamicPropertySupport dynamicPropertySupport) {
        if (dynamicPropertySupport == null) {
            throw new IllegalArgumentException("dynamicPropertySupport is null");
        }
        if (initializedWithDefaultConfig && config instanceof ConfigurationBackedDynamicPropertySupportImpl) {
            ConcurrentCompositeConfiguration concurrentCompositeConfiguration = (ConcurrentCompositeConfiguration)((ConfigurationBackedDynamicPropertySupportImpl)config).getConfiguration();
            DynamicURLConfiguration dynamicURLConfiguration = (DynamicURLConfiguration)concurrentCompositeConfiguration.getConfiguration(URL_CONFIG_NAME);
            if (dynamicURLConfiguration != null) {
                dynamicURLConfiguration.stopLoading();
            }
            Collection<ConfigurationListener> collection = concurrentCompositeConfiguration.getConfigurationListeners();
            ConfigurationListener configurationListener = null;
            for (ConfigurationListener configurationListener2 : collection) {
                if (!(configurationListener2 instanceof ExpandedConfigurationListenerAdapter) || !(((ExpandedConfigurationListenerAdapter)configurationListener2).getListener() instanceof DynamicProperty.DynamicPropertyListener)) continue;
                configurationListener = configurationListener2;
                break;
            }
            if (configurationListener != null) {
                concurrentCompositeConfiguration.removeConfigurationListener(configurationListener);
            }
            if (configMBean != null) {
                try {
                    ConfigJMXManager.unRegisterConfigMBean(concurrentCompositeConfiguration, configMBean);
                }
                catch (Exception exception) {
                    logger.error("Error unregistering with JMX", (Throwable)exception);
                }
            }
            config = null;
        }
        if (config != null && config != dynamicPropertySupport) {
            throw new IllegalStateException("DynamicPropertyFactory is already initialized with a diffrerent configuration source: " + config);
        }
        config = dynamicPropertySupport;
        DynamicProperty.registerWithDynamicPropertySupport(dynamicPropertySupport);
        initializedWithDefaultConfig = false;
        return instance;
    }

    private static boolean shouldInstallDefaultConfig() {
        return !defaultConfigNotFound && !Boolean.getBoolean(DISABLE_DEFAULT_CONFIG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DynamicPropertyFactory getInstance() throws MissingConfigurationSourceException {
        if (config != null || !DynamicPropertyFactory.shouldInstallDefaultConfig()) return instance;
        Throwable throwable = null;
        ConcurrentCompositeConfiguration concurrentCompositeConfiguration = null;
        DynamicURLConfiguration dynamicURLConfiguration = null;
        Class<DynamicPropertyFactory> clazz = DynamicPropertyFactory.class;
        synchronized (DynamicPropertyFactory.class) {
            if (config == null) {
                concurrentCompositeConfiguration = new ConcurrentCompositeConfiguration();
                try {
                    dynamicURLConfiguration = new DynamicURLConfiguration();
                    concurrentCompositeConfiguration.addConfiguration(dynamicURLConfiguration, URL_CONFIG_NAME);
                }
                catch (Throwable throwable2) {
                    defaultConfigNotFound = true;
                    throwable = throwable2;
                }
                if (!Boolean.getBoolean(DISABLE_DEFAULT_SYS_CONFIG)) {
                    SystemConfiguration systemConfiguration = new SystemConfiguration();
                    concurrentCompositeConfiguration.addConfigurationAtFront((AbstractConfiguration)systemConfiguration, SYS_CONFIG_NAME);
                }
                DynamicPropertyFactory.initWithConfigurationSource(concurrentCompositeConfiguration);
                initializedWithDefaultConfig = true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (throwable != null) {
                if (DynamicPropertyFactory.isThrowMissingConfigurationSourceException()) {
                    throw new MissingConfigurationSourceException("Error initializing with default configuration source(s).", throwable);
                }
                logger.warn("Error initializing with default configuration source(s).", throwable);
                return instance;
            } else {
                logger.info("DynamicPropertyFactory is initialized with default configuration source(s): " + dynamicURLConfiguration.getSource());
            }
            return instance;
        }
    }

    private static void checkAndWarn(String string) {
        if (config == null) {
            logger.warn("DynamicProperty " + string + " is created without a configuration source for callback. " + "Need to set property " + "archaius.configurationSource.additionalUrls" + " or call DynamicPropertyFactory.initWithConfigurationSource().");
        }
    }

    public DynamicStringProperty getStringProperty(String string, String string2) {
        return this.getStringProperty(string, string2, null);
    }

    public DynamicStringProperty getStringProperty(String string, String string2, Runnable runnable) {
        DynamicPropertyFactory.checkAndWarn(string);
        DynamicStringProperty dynamicStringProperty = new DynamicStringProperty(string, string2);
        DynamicPropertyFactory.addCallback(runnable, dynamicStringProperty);
        return dynamicStringProperty;
    }

    public DynamicIntProperty getIntProperty(String string, int n) {
        return this.getIntProperty(string, n, null);
    }

    public DynamicIntProperty getIntProperty(String string, int n, Runnable runnable) {
        DynamicPropertyFactory.checkAndWarn(string);
        DynamicIntProperty dynamicIntProperty = new DynamicIntProperty(string, n);
        DynamicPropertyFactory.addCallback(runnable, dynamicIntProperty);
        return dynamicIntProperty;
    }

    public DynamicLongProperty getLongProperty(String string, long l) {
        return this.getLongProperty(string, l, null);
    }

    public DynamicLongProperty getLongProperty(String string, long l, Runnable runnable) {
        DynamicPropertyFactory.checkAndWarn(string);
        DynamicLongProperty dynamicLongProperty = new DynamicLongProperty(string, l);
        DynamicPropertyFactory.addCallback(runnable, dynamicLongProperty);
        return dynamicLongProperty;
    }

    public DynamicBooleanProperty getBooleanProperty(String string, boolean bl) {
        return this.getBooleanProperty(string, bl, null);
    }

    public DynamicBooleanProperty getBooleanProperty(String string, boolean bl, Runnable runnable) {
        DynamicPropertyFactory.checkAndWarn(string);
        DynamicBooleanProperty dynamicBooleanProperty = new DynamicBooleanProperty(string, bl);
        DynamicPropertyFactory.addCallback(runnable, dynamicBooleanProperty);
        return dynamicBooleanProperty;
    }

    public DynamicFloatProperty getFloatProperty(String string, float f) {
        return this.getFloatProperty(string, f, null);
    }

    public DynamicFloatProperty getFloatProperty(String string, float f, Runnable runnable) {
        DynamicPropertyFactory.checkAndWarn(string);
        DynamicFloatProperty dynamicFloatProperty = new DynamicFloatProperty(string, f);
        DynamicPropertyFactory.addCallback(runnable, dynamicFloatProperty);
        return dynamicFloatProperty;
    }

    public DynamicDoubleProperty getDoubleProperty(String string, double d) {
        return this.getDoubleProperty(string, d, null);
    }

    public DynamicDoubleProperty getDoubleProperty(String string, double d, Runnable runnable) {
        DynamicPropertyFactory.checkAndWarn(string);
        DynamicDoubleProperty dynamicDoubleProperty = new DynamicDoubleProperty(string, d);
        DynamicPropertyFactory.addCallback(runnable, dynamicDoubleProperty);
        return dynamicDoubleProperty;
    }

    private static void addCallback(Runnable runnable, PropertyWrapper<?> propertyWrapper) {
        if (runnable != null) {
            propertyWrapper.prop.addCallback(runnable);
        }
    }
}

