/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius;

import com.netflix.archaius.AppConfig;
import com.netflix.archaius.CascadeStrategy;
import com.netflix.archaius.Config;
import com.netflix.archaius.ConfigLoader;
import com.netflix.archaius.ConfigReader;
import com.netflix.archaius.Decoder;
import com.netflix.archaius.DefaultConfigLoader;
import com.netflix.archaius.PropertyContainer;
import com.netflix.archaius.PropertyFactory;
import com.netflix.archaius.StrInterpolatorFactory;
import com.netflix.archaius.cascade.SimpleCascadeStrategy;
import com.netflix.archaius.config.CascadingCompositeConfig;
import com.netflix.archaius.config.EnvironmentConfig;
import com.netflix.archaius.config.SimpleDynamicConfig;
import com.netflix.archaius.config.SystemConfig;
import com.netflix.archaius.exceptions.ConfigException;
import com.netflix.archaius.interpolate.CommonsStrInterpolatorFactory;
import com.netflix.archaius.loaders.PropertiesConfigReader;
import com.netflix.archaius.property.DefaultPropertyContainer;
import com.netflix.archaius.property.PropertyFactoryDynamicConfigListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAppConfig
extends CascadingCompositeConfig
implements AppConfig {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAppConfig.class);
    private static final String DEFAULT_APP_CONFIG_NAME = "config";
    private static final String NAME = "ROOT";
    private static final String OVERRIDE_LAYER = "OVERRIDE";
    private static final String DYNAMIC_LAYER = "DYNAMIC";
    private static final String APPLICATION_LAYER = "APPLICATION";
    private static final String LIBRARY_LAYER = "LIBRARY";
    private static final SimpleCascadeStrategy DEFAULT_CASCADE_STRATEGY = new SimpleCascadeStrategy();
    private final SimpleDynamicConfig runtime;
    private final CascadingCompositeConfig override;
    private final CascadingCompositeConfig library;
    private final DefaultConfigLoader loader;
    private final PropertyFactoryDynamicConfigListener dynamicObserver;

    public static Builder builder() {
        return new Builder();
    }

    public static DefaultAppConfig createDefault() {
        return new Builder().build();
    }

    public DefaultAppConfig(Builder builder) {
        super(NAME);
        try {
            if (builder.decoder != null) {
                this.setDecoder(builder.decoder);
            }
            this.setStrInterpolator(builder.interpolator.create(this));
            this.runtime = new SimpleDynamicConfig(OVERRIDE_LAYER);
            super.addConfig(this.runtime);
            this.runtime.setProperties(builder.props);
            if (builder.enableOverrideLayer) {
                this.override = new CascadingCompositeConfig(DYNAMIC_LAYER);
                super.addConfig(this.override);
            } else {
                this.override = null;
            }
            if (builder.enableSystemLayer) {
                super.addConfig(new SystemConfig());
            }
            if (builder.enableEnvironmentLayer) {
                super.addConfig(new EnvironmentConfig());
            }
            this.loader = DefaultConfigLoader.builder().withConfigReader(builder.loaders).withDefaultCascadingStrategy(builder.defaultStrategy).withFailOnFirst(builder.failOnFirst).withStrInterpolator(this.getStrInterpolator()).build();
            super.addConfig(this.loader.newLoader().withName(APPLICATION_LAYER).load(builder.configName));
            this.library = new CascadingCompositeConfig(LIBRARY_LAYER);
            super.addConfig(this.library);
            this.dynamicObserver = new PropertyFactoryDynamicConfigListener(new PropertyFactory(){

                @Override
                public PropertyContainer getProperty(String propName) {
                    return new DefaultPropertyContainer(propName, DefaultAppConfig.this);
                }
            });
            this.library.addListener(this.dynamicObserver);
            if (this.override != null) {
                this.override.addListener(this.dynamicObserver);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addOverrideConfig(Config child) throws ConfigException {
        LOG.info("Adding configuration : " + child.getName());
        this.override.addConfig(child);
    }

    @Override
    public void addConfig(Config child) throws ConfigException {
        this.addLibraryConfig(child);
    }

    @Override
    public void addLibraryConfig(Config child) throws ConfigException {
        LOG.info("Adding configuration : " + child.getName());
        this.library.addConfig(child);
    }

    @Override
    public ConfigLoader.Loader newLoader() {
        return this.loader.newLoader();
    }

    @Override
    public PropertyContainer getProperty(String propName) {
        return this.dynamicObserver.create(propName);
    }

    public void setProperty(String propName, Object propValue) {
        PropertyContainer prop = this.dynamicObserver.get(propName);
        this.runtime.setProperty(propName, propValue);
        if (prop != null) {
            prop.update();
        }
    }

    @Override
    public void clearProperty(String propName) {
        PropertyContainer prop = this.dynamicObserver.get(propName);
        this.runtime.clearProperty(propName);
        if (prop != null) {
            prop.update();
        }
    }

    @Override
    public void setProperties(Properties properties) {
        this.runtime.setProperties(properties);
        this.dynamicObserver.invalidate();
    }

    public static class Builder {
        private StrInterpolatorFactory interpolator;
        private final List<ConfigReader> loaders = new ArrayList<ConfigReader>();
        private CascadeStrategy defaultStrategy = DefaultAppConfig.access$000();
        private boolean failOnFirst = true;
        private boolean enableSystemLayer = true;
        private boolean enableEnvironmentLayer = true;
        private boolean enableOverrideLayer = true;
        private String configName = "config";
        private Properties props;
        private Decoder decoder;

        public Builder withStrInterpolator(StrInterpolatorFactory interpolator) {
            if (interpolator == null) {
                throw new IllegalArgumentException("StrInterpolatorFactory cannot be null or empty");
            }
            this.interpolator = interpolator;
            return this;
        }

        public Builder withSystemLayer(boolean flag) {
            this.enableSystemLayer = flag;
            return this;
        }

        public Builder withEnvironmentLayer(boolean flag) {
            this.enableEnvironmentLayer = flag;
            return this;
        }

        public Builder withOverrideLayer(boolean flag) {
            this.enableOverrideLayer = flag;
            return this;
        }

        public Builder withConfigReader(ConfigReader loader) {
            if (loader != null) {
                this.loaders.add(loader);
            }
            return this;
        }

        public Builder withDefaultCascadingStrategy(CascadeStrategy strategy) {
            this.defaultStrategy = strategy == null ? DEFAULT_CASCADE_STRATEGY : strategy;
            return this;
        }

        public Builder withFailOnFirst(boolean flag) {
            this.failOnFirst = flag;
            return this;
        }

        public Builder withProperties(Properties props) {
            this.props = props;
            return this;
        }

        public Builder withApplicationConfigName(String name) {
            if (name == null || name.isEmpty()) {
                throw new IllegalArgumentException("Name cannot be null or empty");
            }
            this.configName = name;
            return this;
        }

        public Builder withDecoder(Decoder decoder) {
            if (decoder == null) {
                throw new IllegalArgumentException("Decoder cannot be null");
            }
            this.decoder = decoder;
            return this;
        }

        public DefaultAppConfig build() {
            if (this.interpolator == null) {
                this.interpolator = new CommonsStrInterpolatorFactory();
            }
            if (this.loaders.isEmpty()) {
                this.loaders.add(new PropertiesConfigReader());
            }
            return new DefaultAppConfig(this);
        }
    }
}

