/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius;

import com.netflix.archaius.Decoder;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class DefaultDecoder
implements Decoder {
    @Override
    public <T> T decode(Class<T> type, String encoded) {
        try {
            Constructor<T> c = type.getConstructor(String.class);
            return c.newInstance(encoded);
        }
        catch (NoSuchMethodException e) {
            try {
                Method method = type.getMethod("valueOf", String.class);
                return (T)method.invoke(null, encoded);
            }
            catch (NoSuchMethodException e1) {
                if (type.equals(Boolean.TYPE)) {
                    return (T)Boolean.valueOf(encoded);
                }
                if (type.equals(Integer.TYPE)) {
                    return (T)Integer.valueOf(encoded);
                }
                if (type.equals(Long.TYPE)) {
                    return (T)Long.valueOf(encoded);
                }
                if (type.equals(Short.TYPE)) {
                    return (T)Short.valueOf(encoded);
                }
                if (type.equals(Double.TYPE)) {
                    return (T)Double.valueOf(encoded);
                }
                if (type.equals(Float.TYPE)) {
                    return (T)Float.valueOf(encoded);
                }
            }
            catch (Exception e2) {
                try {
                    throw e2;
                }
                catch (Exception e1) {
                    throw new RuntimeException("Unable to instantiate value of type " + type.getCanonicalName(), e);
                }
            }
            throw new RuntimeException(type.getCanonicalName() + " has no String constructor or valueOf static method");
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate value of type " + type.getCanonicalName(), e);
        }
    }
}

