/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.Config;
import com.netflix.archaius.ConfigListener;
import com.netflix.archaius.Decoder;
import com.netflix.archaius.StrInterpolator;
import com.netflix.archaius.config.CompositeConfig;
import com.netflix.archaius.config.DelegatingConfig;
import com.netflix.archaius.config.ForwardingConfigListener;
import com.netflix.archaius.exceptions.ConfigException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;

public class CascadingCompositeConfig
extends DelegatingConfig
implements CompositeConfig {
    private final CopyOnWriteArrayList<Config> children = new CopyOnWriteArrayList();
    private final Map<String, Config> lookup = new LinkedHashMap<String, Config>();

    public CascadingCompositeConfig(String name) {
        super(name);
    }

    @Override
    public synchronized void addConfig(Config child) throws ConfigException {
        if (child == null) {
            return;
        }
        if (this.lookup.containsKey(child.getName())) {
            throw new ConfigException("Configuration with name " + child.getName() + " already exists");
        }
        this.lookup.put(child.getName(), child);
        this.children.add(child);
        this.postConfigUpdate(child);
    }

    @Override
    public synchronized Collection<String> getConfigNames() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.lookup.keySet());
        return result;
    }

    protected void postConfigUpdate(Config child) {
        child.setStrInterpolator(this.getStrInterpolator());
        child.setDecoder(this.getDecoder());
        this.notifyConfigAdded(child);
        child.addListener(new ForwardingConfigListener(this.getListeners(), this));
    }

    @Override
    public void addConfigs(Collection<Config> config) throws ConfigException {
        for (Config child : config) {
            this.addConfig(child);
        }
    }

    @Override
    public synchronized void replaceConfig(Config child) throws ConfigException {
        for (int i = 0; i < this.children.size(); ++i) {
            if (!this.children.get(i).getName().equals(child.getName())) continue;
            this.children.set(i, child);
            this.postConfigUpdate(child);
            return;
        }
        this.addConfig(child);
    }

    @Override
    public synchronized boolean removeConfig(Config child) {
        if (this.children.remove(child)) {
            this.lookup.remove(child.getName());
            return true;
        }
        return false;
    }

    @Override
    protected Config getConfigWithProperty(String key, boolean failOnNotFound) {
        for (Config child : this.children) {
            if (!child.containsKey(key)) continue;
            return child;
        }
        if (failOnNotFound) {
            throw new NoSuchElementException("No child configuration has property " + key);
        }
        return null;
    }

    @Override
    public boolean containsKey(String key) {
        for (Config child : this.children) {
            if (!child.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        for (Config child : this.children) {
            if (child.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<String> getKeys() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Config config : this.children) {
            Iterator<String> iter = config.getKeys();
            while (iter.hasNext()) {
                String key = iter.next();
                result.add(key);
            }
        }
        return result.iterator();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("[");
        for (Config child : this.children) {
            sb.append(child.toString()).append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void accept(Config.Visitor visitor) {
        if (visitor instanceof CompositeConfig.CompositeVisitor) {
            CompositeConfig.CompositeVisitor cv = (CompositeConfig.CompositeVisitor)((Object)visitor);
            for (Config child : this.children) {
                cv.visit(child);
            }
        } else {
            for (Config child : this.children) {
                child.accept(visitor);
            }
        }
    }

    @Override
    public synchronized void setDecoder(Decoder decoder) {
        super.setDecoder(decoder);
        for (Config config : this.children) {
            this.postConfigUpdate(config);
        }
    }

    @Override
    public synchronized void setStrInterpolator(StrInterpolator interpolator) {
        super.setStrInterpolator(interpolator);
        for (Config config : this.children) {
            this.postConfigUpdate(config);
        }
    }

    @Override
    public synchronized void addListener(ConfigListener listener) {
        super.addListener(listener);
        for (Config config : this.children) {
            this.postConfigUpdate(config);
        }
    }

    @Override
    public synchronized void removeListener(ConfigListener listener) {
        super.removeListener(listener);
        for (Config config : this.children) {
            this.postConfigUpdate(config);
        }
    }
}

