/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.Config;
import com.netflix.archaius.ConfigListener;
import com.netflix.archaius.Decoder;
import com.netflix.archaius.StrInterpolator;
import com.netflix.archaius.config.DelegatingConfig;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;

public class PrefixedViewConfig
extends DelegatingConfig {
    private final Config config;
    private final String prefix;

    public PrefixedViewConfig(String prefix, Config config) {
        super(config.getName() + "|" + prefix);
        this.config = config;
        this.prefix = prefix.endsWith(".") ? prefix : prefix + ".";
    }

    @Override
    public Iterator<String> getKeys() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Iterator<String> iter = this.config.getKeys();
        while (iter.hasNext()) {
            String key = iter.next();
            if (!key.startsWith(this.prefix)) continue;
            result.add(key.substring(this.prefix.length()));
        }
        return result.iterator();
    }

    @Override
    public boolean containsKey(String key) {
        return this.config.containsKey(this.prefix + key);
    }

    @Override
    public boolean isEmpty() {
        return !this.config.getKeys().hasNext();
    }

    @Override
    public void accept(Config.Visitor visitor) {
        this.config.accept(visitor);
    }

    @Override
    protected Config getConfigWithProperty(String key, boolean failOnNotFound) {
        if (this.config.containsKey(this.prefix + key)) {
            return this.config;
        }
        if (failOnNotFound) {
            throw new NoSuchElementException("No child configuration has property " + key);
        }
        return null;
    }

    @Override
    public synchronized void setDecoder(Decoder decoder) {
        super.setDecoder(decoder);
        this.config.setDecoder(decoder);
    }

    @Override
    public synchronized void setStrInterpolator(StrInterpolator interpolator) {
        super.setStrInterpolator(interpolator);
        this.config.setStrInterpolator(interpolator);
    }

    @Override
    public synchronized void addListener(ConfigListener listener) {
        super.addListener(listener);
        this.config.addListener(listener);
    }

    @Override
    public synchronized void removeListener(ConfigListener listener) {
        super.removeListener(listener);
        this.config.removeListener(listener);
    }
}

