/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.property;

import com.netflix.archaius.Config;
import com.netflix.archaius.Property;
import com.netflix.archaius.PropertyContainer;
import com.netflix.archaius.PropertyListener;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPropertyContainer
implements PropertyContainer {
    private final Logger LOG = LoggerFactory.getLogger(DefaultPropertyContainer.class);
    private final String key;
    private final Config config;
    private final CopyOnWriteArrayList<CachedProperty<?>> cache = new CopyOnWriteArrayList();
    private volatile long lastUpdateTimeInMillis = 0L;

    public DefaultPropertyContainer(String key, Config config) {
        this.key = key;
        this.config = config;
    }

    @Override
    public synchronized void update() {
        boolean didUpdate = false;
        for (CachedProperty<?> property : this.cache) {
            didUpdate |= property.update();
        }
        if (didUpdate) {
            this.lastUpdateTimeInMillis = System.currentTimeMillis();
        }
    }

    private <T> CachedProperty<T> add(CachedProperty<T> newProperty) {
        while (!this.cache.addIfAbsent(newProperty)) {
            for (CachedProperty<?> property : this.cache) {
                if (((CachedProperty)property).type != ((CachedProperty)newProperty).type) continue;
                return property;
            }
        }
        newProperty.update();
        return newProperty;
    }

    private <T> CachedProperty<T> get(int type) {
        for (CachedProperty<?> property : this.cache) {
            if (((CachedProperty)property).type != type) continue;
            return property;
        }
        return null;
    }

    @Override
    public Property<String> asString(String defaultValue) {
        CachedProperty<Object> prop = this.get(Type.STRING.ordinal());
        if (prop == null) {
            prop = this.add(new CachedProperty<String>(Type.STRING){

                @Override
                protected String getCurrent() throws Exception {
                    return DefaultPropertyContainer.this.config.getString(DefaultPropertyContainer.this.key, null);
                }
            });
        }
        return new AbstractProperty<String>(prop, defaultValue);
    }

    @Override
    public Property<Integer> asInteger(Integer defaultValue) {
        CachedProperty<Object> prop = this.get(Type.INTEGER.ordinal());
        if (prop == null) {
            prop = this.add(new CachedProperty<Integer>(Type.INTEGER){

                @Override
                protected Integer getCurrent() throws Exception {
                    return DefaultPropertyContainer.this.config.getInteger(DefaultPropertyContainer.this.key, null);
                }
            });
        }
        return new AbstractProperty<Integer>(prop, defaultValue);
    }

    @Override
    public Property<Long> asLong(Long defaultValue) {
        CachedProperty<Object> prop = this.get(Type.LONG.ordinal());
        if (prop == null) {
            prop = this.add(new CachedProperty<Long>(Type.LONG){

                @Override
                protected Long getCurrent() throws Exception {
                    return DefaultPropertyContainer.this.config.getLong(DefaultPropertyContainer.this.key, null);
                }
            });
        }
        return new AbstractProperty<Long>(prop, defaultValue);
    }

    @Override
    public Property<Double> asDouble(Double defaultValue) {
        CachedProperty<Object> prop = this.get(Type.DOUBLE.ordinal());
        if (prop == null) {
            prop = this.add(new CachedProperty<Double>(Type.DOUBLE){

                @Override
                protected Double getCurrent() throws Exception {
                    return DefaultPropertyContainer.this.config.getDouble(DefaultPropertyContainer.this.key, null);
                }
            });
        }
        return new AbstractProperty<Double>(prop, defaultValue);
    }

    @Override
    public Property<Float> asFloat(Float defaultValue) {
        CachedProperty<Object> prop = this.get(Type.FLOAT.ordinal());
        if (prop == null) {
            prop = this.add(new CachedProperty<Float>(Type.FLOAT){

                @Override
                protected Float getCurrent() throws Exception {
                    return DefaultPropertyContainer.this.config.getFloat(DefaultPropertyContainer.this.key, null);
                }
            });
        }
        return new AbstractProperty<Float>(prop, defaultValue);
    }

    @Override
    public Property<Short> asShort(Short defaultValue) {
        CachedProperty<Object> prop = this.get(Type.SHORT.ordinal());
        if (prop == null) {
            prop = this.add(new CachedProperty<Short>(Type.SHORT){

                @Override
                protected Short getCurrent() throws Exception {
                    return DefaultPropertyContainer.this.config.getShort(DefaultPropertyContainer.this.key, null);
                }
            });
        }
        return new AbstractProperty<Short>(prop, defaultValue);
    }

    @Override
    public Property<Byte> asByte(Byte defaultValue) {
        CachedProperty<Object> prop = this.get(Type.BYTE.ordinal());
        if (prop == null) {
            prop = this.add(new CachedProperty<Byte>(Type.BYTE){

                @Override
                protected Byte getCurrent() throws Exception {
                    return DefaultPropertyContainer.this.config.getByte(DefaultPropertyContainer.this.key, null);
                }
            });
        }
        return new AbstractProperty<Byte>(prop, defaultValue);
    }

    @Override
    public Property<BigDecimal> asBigDecimal(BigDecimal defaultValue) {
        CachedProperty<Object> prop = this.get(Type.BIG_DECIMAL.ordinal());
        if (prop == null) {
            prop = this.add(new CachedProperty<BigDecimal>(Type.BIG_DECIMAL){

                @Override
                protected BigDecimal getCurrent() throws Exception {
                    return DefaultPropertyContainer.this.config.getBigDecimal(DefaultPropertyContainer.this.key, null);
                }
            });
        }
        return new AbstractProperty<BigDecimal>(prop, defaultValue);
    }

    @Override
    public Property<Boolean> asBoolean(Boolean defaultValue) {
        CachedProperty<Object> prop = this.get(Type.BOOLEAN.ordinal());
        if (prop == null) {
            prop = this.add(new CachedProperty<Boolean>(Type.BOOLEAN){

                @Override
                protected Boolean getCurrent() throws Exception {
                    return DefaultPropertyContainer.this.config.getBoolean(DefaultPropertyContainer.this.key, null);
                }
            });
        }
        return new AbstractProperty<Boolean>(prop, defaultValue);
    }

    @Override
    public Property<BigInteger> asBigInteger(BigInteger defaultValue) {
        CachedProperty<Object> prop = this.get(Type.BIG_INTEGER.ordinal());
        if (prop == null) {
            prop = this.add(new CachedProperty<BigInteger>(Type.BIG_INTEGER){

                @Override
                protected BigInteger getCurrent() throws Exception {
                    return DefaultPropertyContainer.this.config.getBigInteger(DefaultPropertyContainer.this.key, null);
                }
            });
        }
        return new AbstractProperty<BigInteger>(prop, defaultValue);
    }

    @Override
    public <T> Property<T> asType(Class<T> type, T defaultValue) {
        switch (Type.fromClass(type)) {
            case INTEGER: {
                return this.asInteger((Integer)defaultValue);
            }
            case BYTE: {
                return this.asByte((Byte)defaultValue);
            }
            case SHORT: {
                return this.asShort((Short)defaultValue);
            }
            case DOUBLE: {
                return this.asDouble((Double)defaultValue);
            }
            case FLOAT: {
                return this.asFloat((Float)defaultValue);
            }
            case BOOLEAN: {
                return this.asBoolean((Boolean)defaultValue);
            }
            case STRING: {
                return this.asString((String)defaultValue);
            }
            case LONG: {
                return this.asLong((Long)defaultValue);
            }
            case BIG_DECIMAL: {
                return this.asBigDecimal((BigDecimal)defaultValue);
            }
            case BIG_INTEGER: {
                return this.asBigInteger((BigInteger)defaultValue);
            }
        }
        try {
            final Constructor<T> constructor = type.getConstructor(String.class);
            if (constructor != null) {
                CachedProperty<T> prop = this.add(new CachedProperty<T>(Type.CUSTOM){

                    @Override
                    protected T getCurrent() throws Exception {
                        String value = DefaultPropertyContainer.this.config.getString(DefaultPropertyContainer.this.key);
                        if (value == null) {
                            return null;
                        }
                        return constructor.newInstance(value);
                    }
                });
                return new AbstractProperty<T>(prop, defaultValue);
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException e) {
            throw new UnsupportedOperationException("No parser for type " + type.getName(), e);
        }
        throw new UnsupportedOperationException("No parser for type " + type.getName());
    }

    class AbstractProperty<T>
    implements Property<T> {
        private final CachedProperty<T> delegate;
        private final T defaultValue;

        public AbstractProperty(CachedProperty<T> delegate, T defaultValue) {
            this.delegate = delegate;
            this.defaultValue = defaultValue;
        }

        @Override
        public T get() {
            T value = this.delegate.get();
            return value == null ? this.defaultValue : value;
        }

        @Override
        public long getLastUpdateTime(TimeUnit units) {
            return this.delegate.getLastUpdateTime(units);
        }

        @Override
        public void unsubscribe() {
        }

        @Override
        public Property<T> addListener(PropertyListener<T> listener) {
            this.delegate.addListener(listener);
            return this;
        }

        @Override
        public void removeListener(PropertyListener<T> listener) {
            this.delegate.removeListener(listener);
        }
    }

    abstract class CachedProperty<T> {
        private volatile T existing = null;
        private CopyOnWriteArraySet<PropertyListener<T>> listeners = new CopyOnWriteArraySet();
        private final int type;

        public int hashCode() {
            return this.type;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CachedProperty other = (CachedProperty)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return this.type == other.type;
        }

        CachedProperty(Type type) {
            this.type = type.ordinal();
        }

        public void addListener(PropertyListener<T> listener) {
            this.listeners.add(listener);
        }

        public void removeListener(PropertyListener<T> listener) {
            this.listeners.remove(listener);
        }

        boolean update() {
            try {
                T next = this.getCurrent();
                if ((next == null || this.existing == null) && next == this.existing) {
                    return false;
                }
                if (next == null || this.existing == null || !this.existing.equals(next)) {
                    this.existing = next;
                    for (PropertyListener<T> observer : this.listeners) {
                        observer.onChange(this.existing);
                    }
                    return true;
                }
            }
            catch (Exception e) {
                DefaultPropertyContainer.this.LOG.warn("Unable to get current version of property '{}'. Error: {}", (Object)DefaultPropertyContainer.this.key, (Object)e.getMessage());
                for (PropertyListener<T> observer : this.listeners) {
                    observer.onParseError(e);
                }
            }
            return false;
        }

        public T get() {
            return this.existing;
        }

        public long getLastUpdateTime(TimeUnit units) {
            return units.convert(DefaultPropertyContainer.this.lastUpdateTimeInMillis, TimeUnit.MILLISECONDS);
        }

        private DefaultPropertyContainer getOuterType() {
            return DefaultPropertyContainer.this;
        }

        protected abstract T getCurrent() throws Exception;
    }

    static enum Type {
        INTEGER(Integer.TYPE, Integer.class),
        BYTE(Byte.TYPE, Byte.class),
        SHORT(Short.TYPE, Short.class),
        DOUBLE(Double.TYPE, Double.class),
        FLOAT(Float.TYPE, Float.class),
        BOOLEAN(Boolean.TYPE, Boolean.class),
        LONG(Long.TYPE, Long.class),
        STRING(String.class),
        BIG_DECIMAL(BigDecimal.class),
        BIG_INTEGER(BigInteger.class),
        CUSTOM(new Class[0]);

        private final Class<?>[] types;

        private Type(Class<?> ... type) {
            this.types = type;
        }

        static Type fromClass(Class<?> clazz) {
            for (Type type : Type.values()) {
                for (Class<?> cls : type.types) {
                    if (!cls.equals(clazz)) continue;
                    return type;
                }
            }
            return CUSTOM;
        }
    }
}

