/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.property;

import com.netflix.archaius.Config;
import com.netflix.archaius.ConfigListener;
import com.netflix.archaius.PropertyContainer;
import com.netflix.archaius.PropertyFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class PropertyFactoryDynamicConfigListener
implements ConfigListener {
    private final ConcurrentMap<String, PropertyContainer> registry = new ConcurrentHashMap<String, PropertyContainer>();
    private final PropertyFactory factory;

    public PropertyFactoryDynamicConfigListener(PropertyFactory factory) {
        this.factory = factory;
    }

    @Override
    public void onConfigAdded(Config config) {
        this.invalidate();
    }

    @Override
    public void onConfigRemoved(Config config) {
        this.invalidate();
    }

    @Override
    public void onError(Throwable error, Config config) {
    }

    @Override
    public void onConfigUpdated(Config config) {
        this.invalidate();
    }

    public void invalidate() {
        for (PropertyContainer prop : this.registry.values()) {
            prop.update();
        }
    }

    public PropertyContainer create(String key) {
        PropertyContainer existing;
        PropertyContainer container = (PropertyContainer)this.registry.get(key);
        if (container == null && (existing = this.registry.putIfAbsent(key, container = this.factory.getProperty(key))) != null) {
            return existing;
        }
        return container;
    }

    public PropertyContainer get(String key) {
        return (PropertyContainer)this.registry.get(key);
    }
}

