/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.model;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.serializers.AsciiSerializer;
import com.netflix.astyanax.serializers.BigIntegerSerializer;
import com.netflix.astyanax.serializers.BooleanSerializer;
import com.netflix.astyanax.serializers.ByteBufferOutputStream;
import com.netflix.astyanax.serializers.ByteBufferSerializer;
import com.netflix.astyanax.serializers.ComparatorType;
import com.netflix.astyanax.serializers.IntegerSerializer;
import com.netflix.astyanax.serializers.LongSerializer;
import com.netflix.astyanax.serializers.SerializerTypeInferer;
import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.astyanax.serializers.UUIDSerializer;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class AbstractComposite
extends AbstractList<Object>
implements Comparable<AbstractComposite> {
    static final Logger logger = Logger.getLogger(AbstractComposite.class.getName());
    public static final BiMap<Class<? extends Serializer>, String> DEFAULT_SERIALIZER_TO_COMPARATOR_MAPPING = new ImmutableBiMap.Builder().put(AsciiSerializer.class, (Object)AsciiSerializer.get().getComparatorType().getTypeName()).put(BigIntegerSerializer.class, (Object)BigIntegerSerializer.get().getComparatorType().getTypeName()).put(LongSerializer.class, (Object)LongSerializer.get().getComparatorType().getTypeName()).put(IntegerSerializer.class, (Object)IntegerSerializer.get().getComparatorType().getTypeName()).put(BooleanSerializer.class, (Object)BooleanSerializer.get().getComparatorType().getTypeName()).put(StringSerializer.class, (Object)StringSerializer.get().getComparatorType().getTypeName()).put(UUIDSerializer.class, (Object)UUIDSerializer.get().getComparatorType().getTypeName()).build();
    static final ImmutableClassToInstanceMap<Serializer> SERIALIZERS = new ImmutableClassToInstanceMap.Builder().put(IntegerSerializer.class, (Object)IntegerSerializer.get()).put(BooleanSerializer.class, (Object)BooleanSerializer.get()).put(AsciiSerializer.class, (Object)AsciiSerializer.get()).put(BigIntegerSerializer.class, (Object)BigIntegerSerializer.get()).put(ByteBufferSerializer.class, (Object)ByteBufferSerializer.get()).put(LongSerializer.class, (Object)LongSerializer.get()).put(StringSerializer.class, (Object)StringSerializer.get()).put(UUIDSerializer.class, (Object)UUIDSerializer.get()).build();
    public static final BiMap<Byte, String> DEFAULT_ALIAS_TO_COMPARATOR_MAPPING = new ImmutableBiMap.Builder().put((Object)97, (Object)ComparatorType.ASCIITYPE.getTypeName()).put((Object)98, (Object)ComparatorType.BYTESTYPE.getTypeName()).put((Object)105, (Object)ComparatorType.INTEGERTYPE.getTypeName()).put((Object)120, (Object)ComparatorType.LEXICALUUIDTYPE.getTypeName()).put((Object)108, (Object)ComparatorType.LONGTYPE.getTypeName()).put((Object)116, (Object)ComparatorType.TIMEUUIDTYPE.getTypeName()).put((Object)115, (Object)ComparatorType.UTF8TYPE.getTypeName()).put((Object)117, (Object)ComparatorType.UUIDTYPE.getTypeName()).build();
    BiMap<Class<? extends Serializer>, String> serializerToComparatorMapping = DEFAULT_SERIALIZER_TO_COMPARATOR_MAPPING;
    BiMap<Byte, String> aliasToComparatorMapping = DEFAULT_ALIAS_TO_COMPARATOR_MAPPING;
    final boolean dynamic;
    List<Serializer<?>> serializersByPosition = null;
    List<String> comparatorsByPosition = null;
    List<Component<?>> components = new ArrayList();
    ByteBuffer serialized = null;

    public AbstractComposite(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public AbstractComposite(boolean dynamic, Object ... o) {
        this.dynamic = dynamic;
        this.addAll((Collection<? extends Object>)Arrays.asList(o));
    }

    public AbstractComposite(boolean dynamic, List<?> l) {
        this.dynamic = dynamic;
        this.addAll((Collection<? extends Object>)l);
    }

    public List<Component<?>> getComponents() {
        return this.components;
    }

    public void setComponents(List<Component<?>> components) {
        this.serialized = null;
        this.components = components;
    }

    public Map<Class<? extends Serializer>, String> getSerializerToComparatorMapping() {
        return this.serializerToComparatorMapping;
    }

    public void setSerializerToComparatorMapping(Map<Class<? extends Serializer>, String> serializerToComparatorMapping) {
        this.serialized = null;
        this.serializerToComparatorMapping = new ImmutableBiMap.Builder().putAll(serializerToComparatorMapping).build();
    }

    public Map<Byte, String> getAliasesToComparatorMapping() {
        return this.aliasToComparatorMapping;
    }

    public void setAliasesToComparatorMapping(Map<Byte, String> aliasesToComparatorMapping) {
        this.serialized = null;
        this.aliasToComparatorMapping = new ImmutableBiMap.Builder().putAll(aliasesToComparatorMapping).build();
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public List<Serializer<?>> getSerializersByPosition() {
        return this.serializersByPosition;
    }

    public void setSerializersByPosition(List<Serializer<?>> serializersByPosition) {
        this.serializersByPosition = serializersByPosition;
    }

    public void setSerializersByPosition(Serializer<?> ... serializers) {
        this.serializersByPosition = Arrays.asList(serializers);
    }

    public void setSerializerByPosition(int index, Serializer<?> s) {
        if (this.serializersByPosition == null) {
            this.serializersByPosition = new ArrayList();
        }
        while (this.serializersByPosition.size() <= index) {
            this.serializersByPosition.add(null);
        }
        this.serializersByPosition.set(index, s);
    }

    public List<String> getComparatorsByPosition() {
        return this.comparatorsByPosition;
    }

    public void setComparatorsByPosition(List<String> comparatorsByPosition) {
        this.comparatorsByPosition = comparatorsByPosition;
    }

    public void setComparatorsByPosition(String ... comparators) {
        this.comparatorsByPosition = Arrays.asList(comparators);
    }

    public void setComparatorByPosition(int index, String c) {
        if (this.comparatorsByPosition == null) {
            this.comparatorsByPosition = new ArrayList<String>();
        }
        while (this.comparatorsByPosition.size() <= index) {
            this.comparatorsByPosition.add(null);
        }
        this.comparatorsByPosition.set(index, c);
    }

    @Override
    public int compareTo(AbstractComposite o) {
        return this.serialize().compareTo(o.serialize());
    }

    private String comparatorForSerializer(Serializer<?> s) {
        String comparator = (String)this.serializerToComparatorMapping.get(s.getClass());
        if (comparator != null) {
            return comparator;
        }
        return ComparatorType.BYTESTYPE.getTypeName();
    }

    private Serializer<?> serializerForComparator(String c) {
        int p = c.indexOf(40);
        if (p >= 0) {
            c = c.substring(0, p);
        }
        if (ComparatorType.LEXICALUUIDTYPE.getTypeName().equals(c) || ComparatorType.TIMEUUIDTYPE.getTypeName().equals(c)) {
            return UUIDSerializer.get();
        }
        Serializer s = (Serializer)SERIALIZERS.getInstance((Class)this.serializerToComparatorMapping.inverse().get((Object)c));
        if (s != null) {
            return s;
        }
        return ByteBufferSerializer.get();
    }

    private Serializer<?> serializerForPosition(int i) {
        if (this.serializersByPosition == null) {
            return null;
        }
        if (i >= this.serializersByPosition.size()) {
            return null;
        }
        return this.serializersByPosition.get(i);
    }

    private Serializer<?> getSerializer(int i, String c) {
        Serializer<?> s = this.serializerForPosition(i);
        if (s != null) {
            return s;
        }
        return this.serializerForComparator(c);
    }

    private String comparatorForPosition(int i) {
        if (this.comparatorsByPosition == null) {
            return null;
        }
        if (i >= this.comparatorsByPosition.size()) {
            return null;
        }
        return this.comparatorsByPosition.get(i);
    }

    private String getComparator(int i, ByteBuffer bb) {
        String name = this.comparatorForPosition(i);
        if (name != null) {
            return name;
        }
        if (!this.dynamic) {
            if (bb.hasRemaining()) {
                return ComparatorType.BYTESTYPE.getTypeName();
            }
            return null;
        }
        if (bb.hasRemaining()) {
            try {
                int header = AbstractComposite.getShortLength(bb);
                if ((header & 0x8000) == 0) {
                    name = ByteBufferUtil.string((ByteBuffer)AbstractComposite.getBytes(bb, header));
                } else {
                    byte a = (byte)(header & 0xFF);
                    name = (String)this.aliasToComparatorMapping.get((Object)a);
                    if (name == null && (name = (String)this.aliasToComparatorMapping.get((Object)(a = (byte)Character.toUpperCase((char)a)))) != null) {
                        name = name + "(reversed=true)";
                    }
                }
            }
            catch (CharacterCodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (name != null && name.length() == 0) {
            name = null;
        }
        return name;
    }

    @Override
    public void clear() {
        this.serialized = null;
        this.components = new ArrayList();
    }

    @Override
    public int size() {
        return this.components.size();
    }

    public <T> AbstractComposite addComponent(T value, Serializer<T> s) {
        this.addComponent(value, s, this.comparatorForSerializer(s));
        return this;
    }

    public <T> AbstractComposite addComponent(T value, Serializer<T> s, ComponentEquality equality) {
        this.addComponent(value, s, this.comparatorForSerializer(s), equality);
        return this;
    }

    public <T> AbstractComposite addComponent(T value, Serializer<T> s, String comparator) {
        this.addComponent(value, s, comparator, ComponentEquality.EQUAL);
        return this;
    }

    public <T> AbstractComposite addComponent(T value, Serializer<T> s, String comparator, ComponentEquality equality) {
        this.addComponent(-1, value, s, comparator, equality);
        return this;
    }

    public <T> AbstractComposite addComponent(int index, T value, Serializer<T> s, String comparator, ComponentEquality equality) {
        this.serialized = null;
        if (index < 0) {
            index = this.components.size();
        }
        while (this.components.size() < index) {
            this.components.add(null);
        }
        this.components.add(index, new Component<T>(value, null, s, comparator, equality));
        return this;
    }

    private static Object mapIfNumber(Object o) {
        if (o instanceof Byte || o instanceof Integer || o instanceof Short) {
            return BigInteger.valueOf(((Number)o).longValue());
        }
        return o;
    }

    private static Collection<?> flatten(Collection<?> c) {
        if (c instanceof AbstractComposite) {
            return ((AbstractComposite)c).getComponents();
        }
        boolean hasCollection = false;
        for (Object o : c) {
            if (!(o instanceof Collection)) continue;
            hasCollection = true;
            break;
        }
        if (!hasCollection) {
            return c;
        }
        ArrayList newList = new ArrayList();
        for (Object o : c) {
            if (o instanceof Collection) {
                newList.addAll(AbstractComposite.flatten((Collection)o));
                continue;
            }
            newList.add(o);
        }
        return newList;
    }

    @Override
    public boolean addAll(Collection<? extends Object> c) {
        return super.addAll(AbstractComposite.flatten(c));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return super.containsAll(AbstractComposite.flatten(c));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return super.removeAll(AbstractComposite.flatten(c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return super.retainAll(AbstractComposite.flatten(c));
    }

    @Override
    public boolean addAll(int i, Collection<? extends Object> c) {
        return super.addAll(i, AbstractComposite.flatten(c));
    }

    @Override
    public void add(int index, Object element) {
        String c;
        this.serialized = null;
        if (element instanceof Component) {
            this.components.add(index, (Component)element);
            return;
        }
        element = AbstractComposite.mapIfNumber(element);
        Serializer<Object> s = this.serializerForPosition(index);
        if (s == null) {
            s = SerializerTypeInferer.getSerializer(element);
        }
        if ((c = this.comparatorForPosition(index)) == null) {
            c = this.comparatorForSerializer(s);
        }
        this.components.add(index, new Component<Object>(element, null, s, c, ComponentEquality.EQUAL));
    }

    @Override
    public Object remove(int index) {
        this.serialized = null;
        Component<?> prev = this.components.remove(index);
        if (prev != null) {
            return prev.getValue();
        }
        return null;
    }

    public <T> AbstractComposite setComponent(int index, T value, Serializer<T> s) {
        this.setComponent(index, value, s, this.comparatorForSerializer(s));
        return this;
    }

    public <T> AbstractComposite setComponent(int index, T value, Serializer<T> s, String comparator) {
        this.setComponent(index, value, s, comparator, ComponentEquality.EQUAL);
        return this;
    }

    public <T> AbstractComposite setComponent(int index, T value, Serializer<T> s, String comparator, ComponentEquality equality) {
        this.serialized = null;
        while (this.components.size() <= index) {
            this.components.add(null);
        }
        this.components.set(index, new Component<T>(value, null, s, comparator, equality));
        return this;
    }

    @Override
    public Object set(int index, Object element) {
        Component<Object> prev;
        String c;
        this.serialized = null;
        if (element instanceof Component) {
            Component prev2 = this.components.set(index, (Component)element);
            if (prev2 != null) {
                return prev2.getValue();
            }
            return null;
        }
        element = AbstractComposite.mapIfNumber(element);
        Serializer<Object> s = this.serializerForPosition(index);
        if (s == null) {
            s = SerializerTypeInferer.getSerializer(element);
        }
        if ((c = this.comparatorForPosition(index)) == null) {
            c = this.comparatorForSerializer(s);
        }
        if ((prev = this.components.set(index, new Component<Object>(element, null, s, c, ComponentEquality.EQUAL))) != null) {
            return prev.getValue();
        }
        return null;
    }

    @Override
    public Object get(int i) {
        Component<?> c = this.components.get(i);
        if (c != null) {
            return c.getValue();
        }
        return null;
    }

    public <T> T get(int i, Serializer<T> s) throws ClassCastException {
        T value = null;
        Component<?> c = this.components.get(i);
        if (c != null) {
            value = c.getValue(s);
        }
        return value;
    }

    public Component getComponent(int i) {
        if (i >= this.components.size()) {
            return null;
        }
        Component<?> c = this.components.get(i);
        return c;
    }

    public Iterator<Component<?>> componentsIterator() {
        return this.components.iterator();
    }

    public ByteBuffer serialize() {
        if (this.serialized != null) {
            return this.serialized.duplicate();
        }
        ByteBufferOutputStream out = new ByteBufferOutputStream();
        int i = 0;
        for (Component<?> c : this.components) {
            Serializer<?> s;
            ByteBuffer cb = c.getBytes(s = this.serializerForPosition(i));
            if (cb == null) {
                cb = ByteBuffer.allocate(0);
            }
            if (this.dynamic) {
                String comparator = this.comparatorForPosition(i);
                if (comparator == null) {
                    comparator = c.getComparator();
                }
                if (comparator == null) {
                    comparator = ComparatorType.BYTESTYPE.getTypeName();
                }
                int p = comparator.indexOf("(reversed=true)");
                boolean desc = false;
                if (p >= 0) {
                    comparator = comparator.substring(0, p);
                    desc = true;
                }
                if (this.aliasToComparatorMapping.inverse().containsKey((Object)comparator)) {
                    byte a = (Byte)this.aliasToComparatorMapping.inverse().get((Object)comparator);
                    if (desc) {
                        a = (byte)Character.toUpperCase((char)a);
                    }
                    out.writeShort((short)(0x8000 | a));
                } else {
                    out.writeShort((short)comparator.length());
                    out.write(ByteBufferUtil.bytes((String)comparator));
                }
            }
            out.writeShort((short)cb.remaining());
            out.write(cb.slice());
            out.write(c.getEquality().toByte());
            ++i;
        }
        this.serialized = out.getByteBuffer();
        return this.serialized.duplicate();
    }

    public void deserialize(ByteBuffer b) {
        this.serialized = b.duplicate();
        this.components = new ArrayList();
        String comparator = null;
        int i = 0;
        while ((comparator = this.getComparator(i, b)) != null) {
            ByteBuffer data = AbstractComposite.getWithShortLength(b);
            if (data == null) {
                throw new RuntimeException("Missing component data in composite type");
            }
            Serializer<?> s = this.getSerializer(i, comparator);
            ComponentEquality equality = ComponentEquality.fromByte(b.get());
            this.components.add(new Component<Object>(null, data.slice(), s, comparator, equality));
            ++i;
        }
    }

    protected static int getShortLength(ByteBuffer bb) {
        int length = (bb.get() & 0xFF) << 8;
        return length | bb.get() & 0xFF;
    }

    protected static ByteBuffer getBytes(ByteBuffer bb, int length) {
        ByteBuffer copy = bb.duplicate();
        copy.limit(copy.position() + length);
        bb.position(bb.position() + length);
        return copy;
    }

    protected static ByteBuffer getWithShortLength(ByteBuffer bb) {
        int length = AbstractComposite.getShortLength(bb);
        return AbstractComposite.getBytes(bb, length);
    }

    public class Component<T> {
        final Serializer<T> serializer;
        final T value;
        final ByteBuffer bytes;
        final String comparator;
        final ComponentEquality equality;

        public Component(T value, ByteBuffer bytes, Serializer<T> serializer, String comparator, ComponentEquality equality) {
            this.serializer = serializer;
            this.value = value;
            this.bytes = bytes;
            this.comparator = comparator;
            this.equality = equality;
        }

        public Serializer<T> getSerializer() {
            return this.serializer;
        }

        public <A> A getValue(Serializer<A> s) {
            ByteBuffer cb;
            if (s == null) {
                s = this.serializer;
            }
            if (this.value == null && this.bytes != null && s != null && (cb = this.bytes.duplicate()).hasRemaining()) {
                return (A)s.fromByteBuffer(cb);
            }
            if (this.value instanceof ByteBuffer) {
                return (A)((ByteBuffer)this.value).duplicate();
            }
            return (A)this.value;
        }

        public T getValue() {
            return this.getValue(this.serializer);
        }

        public <A> ByteBuffer getBytes(Serializer<A> s) {
            if (this.bytes == null) {
                if (this.value instanceof ByteBuffer) {
                    return ((ByteBuffer)this.value).duplicate();
                }
                if (this.value == null) {
                    return null;
                }
                if (s == null) {
                    s = this.serializer;
                }
                if (s != null) {
                    return s.toByteBuffer(this.value).duplicate();
                }
            }
            return this.bytes.duplicate();
        }

        public ByteBuffer getBytes() {
            return this.getBytes(this.serializer);
        }

        public String getComparator() {
            return this.comparator;
        }

        public ComponentEquality getEquality() {
            return this.equality;
        }

        public String toString() {
            return "Component [" + this.getValue() + "]";
        }
    }

    public static enum ComponentEquality {
        LESS_THAN_EQUAL(-1),
        EQUAL(0),
        GREATER_THAN_EQUAL(1);

        private final byte equality;

        private ComponentEquality(byte equality) {
            this.equality = equality;
        }

        public byte toByte() {
            return this.equality;
        }

        public static ComponentEquality fromByte(byte equality) {
            if (equality > 0) {
                return GREATER_THAN_EQUAL;
            }
            if (equality < 0) {
                return LESS_THAN_EQUAL;
            }
            return EQUAL;
        }
    }
}

