/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool.impl;

import com.netflix.astyanax.connectionpool.ConnectionPoolConfiguration;
import com.netflix.astyanax.connectionpool.RetryBackoffStrategy;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;

public class ExponentialRetryBackoffStrategy
implements RetryBackoffStrategy {
    private final ConnectionPoolConfiguration config;

    public ExponentialRetryBackoffStrategy(ConnectionPoolConfiguration config) {
        this.config = config;
    }

    public String toString() {
        return "ExpRetry[" + "max=" + this.config.getRetryMaxDelaySlice() + ",slot=" + this.config.getRetryDelaySlice() + ",suspend=" + this.config.getRetrySuspendWindow() + "]";
    }

    @Override
    public RetryBackoffStrategy.Instance createInstance() {
        return new RetryBackoffStrategy.Instance(){
            private int c = 1;
            private AtomicBoolean isSuspended = new AtomicBoolean(false);
            private int attemptCount = 0;
            private long lastReconnectTime = 0L;

            @Override
            public long getNextDelay() {
                if (this.isSuspended.get()) {
                    this.isSuspended.set(false);
                    return ExponentialRetryBackoffStrategy.this.config.getRetrySuspendWindow();
                }
                ++this.attemptCount;
                if (this.attemptCount == 1 && System.currentTimeMillis() - this.lastReconnectTime < (long)ExponentialRetryBackoffStrategy.this.config.getRetrySuspendWindow()) {
                    return ExponentialRetryBackoffStrategy.this.config.getRetrySuspendWindow();
                }
                this.c *= 2;
                if (this.c > ExponentialRetryBackoffStrategy.this.config.getRetryMaxDelaySlice()) {
                    this.c = ExponentialRetryBackoffStrategy.this.config.getRetryMaxDelaySlice();
                }
                return (new Random().nextInt(this.c) + 1) * ExponentialRetryBackoffStrategy.this.config.getRetryDelaySlice();
            }

            @Override
            public int getAttemptCount() {
                return this.attemptCount;
            }

            public String toString() {
                return "ExpRetry.Instance[" + this.c + "," + this.isSuspended + "," + this.attemptCount + "]";
            }

            @Override
            public void begin() {
                this.attemptCount = 0;
                this.c = 1;
            }

            @Override
            public void success() {
                this.lastReconnectTime = System.currentTimeMillis();
            }

            @Override
            public void suspend() {
                this.isSuspended.set(true);
            }
        };
    }
}

