/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.retry;

import com.netflix.astyanax.retry.RetryPolicy;
import com.netflix.astyanax.retry.SleepingRetryPolicy;
import java.util.Random;
import org.apache.commons.lang.builder.ToStringBuilder;

public class ExponentialBackoff
extends SleepingRetryPolicy {
    private final int MAX_SHIFT = 30;
    private final Random random = new Random();
    private final long baseSleepTimeMs;

    public ExponentialBackoff(long baseSleepTimeMs, int maxAttempts) {
        super(maxAttempts);
        this.baseSleepTimeMs = baseSleepTimeMs;
    }

    @Override
    public long getSleepTimeMs() {
        int attempt = this.getAttemptCount() + 1;
        if (attempt > 30) {
            attempt = 30;
        }
        return this.baseSleepTimeMs * (long)Math.max(1, this.random.nextInt(1 << attempt));
    }

    public long getBaseSleepTimeMs() {
        return this.baseSleepTimeMs;
    }

    @Override
    public RetryPolicy duplicate() {
        return new ExponentialBackoff(this.baseSleepTimeMs, this.getMaxAttemptCount());
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

