/*******************************************************************************
 * Copyright 2011 Netflix
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/

package com.netflix.astyanax.util;

import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;

public class BarrierCallableDecorator<T> implements Callable<T> {
    public CyclicBarrier barrier;
    public Callable<T> callable;
    
    public BarrierCallableDecorator(CyclicBarrier barrier, Callable<T> callable) {
        this.barrier = barrier;
        this.callable = callable;
    }
    
    @Override
    public T call() throws Exception {
        barrier.await();
        return callable.call();
    }

}
