/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.recipes.atomic;

import com.netflix.curator.RetryPolicy;
import com.netflix.curator.framework.CuratorFramework;
import com.netflix.curator.framework.api.BackgroundPathAndBytesable;
import com.netflix.curator.framework.api.WatchPathable;
import com.netflix.curator.framework.recipes.atomic.AtomicValue;
import com.netflix.curator.framework.recipes.atomic.MakeValue;
import com.netflix.curator.framework.recipes.atomic.MutableAtomicValue;
import com.netflix.curator.framework.recipes.atomic.PromotedToLock;
import com.netflix.curator.framework.recipes.locks.InterProcessMutex;
import java.util.Arrays;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

public class DistributedAtomicValue {
    private final CuratorFramework client;
    private final String path;
    private final RetryPolicy retryPolicy;
    private final PromotedToLock promotedToLock;
    private final InterProcessMutex mutex;

    public DistributedAtomicValue(CuratorFramework client, String path, RetryPolicy retryPolicy) {
        this(client, path, retryPolicy, null);
    }

    public DistributedAtomicValue(CuratorFramework client, String path, RetryPolicy retryPolicy, PromotedToLock promotedToLock) {
        this.client = client;
        this.path = path;
        this.retryPolicy = retryPolicy;
        this.promotedToLock = promotedToLock;
        this.mutex = promotedToLock != null ? new InterProcessMutex(client, promotedToLock.getPath()) : null;
    }

    public AtomicValue<byte[]> get() throws Exception {
        MutableAtomicValue<Object> result = new MutableAtomicValue<Object>(null, null, false);
        this.getCurrentValue(result, new Stat());
        result.postValue = result.preValue;
        result.succeeded = true;
        return result;
    }

    public void forceSet(byte[] newValue) throws Exception {
        try {
            this.client.setData().forPath(this.path, newValue);
        }
        catch (KeeperException.NoNodeException dummy) {
            try {
                this.client.create().forPath(this.path, newValue);
            }
            catch (KeeperException.NodeExistsException dummy2) {
                this.client.setData().forPath(this.path, newValue);
            }
        }
    }

    public AtomicValue<byte[]> compareAndSet(byte[] expectedValue, byte[] newValue) throws Exception {
        MutableAtomicValue<Object> result = new MutableAtomicValue<Object>(null, null, false);
        Stat stat = new Stat();
        boolean createIt = this.getCurrentValue(result, stat);
        if (!createIt && Arrays.equals(expectedValue, (byte[])result.preValue)) {
            try {
                ((BackgroundPathAndBytesable)this.client.setData().withVersion(stat.getVersion())).forPath(this.path, newValue);
                result.succeeded = true;
                result.postValue = newValue;
            }
            catch (KeeperException.BadVersionException dummy) {
                result.succeeded = false;
            }
            catch (KeeperException.NoNodeException dummy) {
                result.succeeded = false;
            }
        } else {
            result.succeeded = false;
        }
        return result;
    }

    public AtomicValue<byte[]> trySet(final byte[] newValue) throws Exception {
        MutableAtomicValue<Object> result = new MutableAtomicValue<Object>(null, null, false);
        MakeValue makeValue = new MakeValue(){

            @Override
            public byte[] makeFrom(byte[] previous) {
                return newValue;
            }
        };
        this.tryOptimistic(result, makeValue);
        if (!result.succeeded() && this.mutex != null) {
            this.tryWithMutex(result, makeValue);
        }
        return result;
    }

    AtomicValue<byte[]> trySet(MakeValue makeValue) throws Exception {
        MutableAtomicValue<Object> result = new MutableAtomicValue<Object>(null, null, false);
        this.tryOptimistic(result, makeValue);
        if (!result.succeeded() && this.mutex != null) {
            this.tryWithMutex(result, makeValue);
        }
        return result;
    }

    private boolean getCurrentValue(MutableAtomicValue<byte[]> result, Stat stat) throws Exception {
        boolean createIt = false;
        try {
            result.preValue = ((WatchPathable)this.client.getData().storingStatIn(stat)).forPath(this.path);
        }
        catch (KeeperException.NoNodeException e) {
            result.preValue = null;
            createIt = true;
        }
        return createIt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryWithMutex(MutableAtomicValue<byte[]> result, MakeValue makeValue) throws Exception {
        long startMs = System.currentTimeMillis();
        int retryCount = 0;
        if (this.mutex.acquire(this.promotedToLock.getMaxLockTime(), this.promotedToLock.getMaxLockTimeUnit())) {
            try {
                boolean done = false;
                while (!done) {
                    result.stats.incrementPromotedTries();
                    if (this.tryOnce(result, makeValue)) {
                        result.succeeded = true;
                        done = true;
                        continue;
                    }
                    if (this.promotedToLock.getRetryPolicy().allowRetry(retryCount++, System.currentTimeMillis() - startMs)) continue;
                    done = true;
                }
            }
            finally {
                this.mutex.release();
            }
        }
        result.stats.setPromotedTimeMs(System.currentTimeMillis() - startMs);
    }

    private void tryOptimistic(MutableAtomicValue<byte[]> result, MakeValue makeValue) throws Exception {
        long startMs = System.currentTimeMillis();
        int retryCount = 0;
        boolean done = false;
        while (!done) {
            result.stats.incrementOptimisticTries();
            if (this.tryOnce(result, makeValue)) {
                result.succeeded = true;
                done = true;
                continue;
            }
            if (this.retryPolicy.allowRetry(retryCount++, System.currentTimeMillis() - startMs)) continue;
            done = true;
        }
        result.stats.setOptimisticTimeMs(System.currentTimeMillis() - startMs);
    }

    private boolean tryOnce(MutableAtomicValue<byte[]> result, MakeValue makeValue) throws Exception {
        Stat stat = new Stat();
        boolean createIt = this.getCurrentValue(result, stat);
        boolean success = false;
        try {
            byte[] newValue = makeValue.makeFrom((byte[])result.preValue);
            if (createIt) {
                this.client.create().forPath(this.path, newValue);
            } else {
                ((BackgroundPathAndBytesable)this.client.setData().withVersion(stat.getVersion())).forPath(this.path, newValue);
            }
            result.postValue = Arrays.copyOf(newValue, newValue.length);
            success = true;
        }
        catch (KeeperException.NodeExistsException e) {
        }
        catch (KeeperException.BadVersionException e) {
        }
        catch (KeeperException.NoNodeException e) {
            // empty catch block
        }
        return success;
    }
}

