/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.recipes.cache;

import com.netflix.curator.framework.recipes.cache.PathChildrenCacheMode;
import org.apache.zookeeper.data.Stat;

public class ChildData
implements Comparable<ChildData> {
    private final String path;
    private final Stat stat;
    private final byte[] data;
    private final long thisObjectCreationTimeMs = System.currentTimeMillis();

    ChildData(String path, Stat stat, byte[] data) {
        this.path = path;
        this.stat = stat;
        this.data = data;
    }

    boolean isComplete(PathChildrenCacheMode mode) {
        boolean isComplete = false;
        if (this.path != null) {
            switch (mode) {
                case CACHE_DATA_AND_STAT: {
                    isComplete = this.stat != null && this.data != null;
                    break;
                }
                case CACHE_DATA: {
                    isComplete = this.data != null;
                    break;
                }
                case CACHE_PATHS_ONLY: {
                    isComplete = true;
                }
            }
        }
        return isComplete;
    }

    long getThisObjectCreationTimeMs() {
        return this.thisObjectCreationTimeMs;
    }

    @Override
    public int compareTo(ChildData rhs) {
        if (this == rhs) {
            return 0;
        }
        if (rhs == null || this.getClass() != rhs.getClass()) {
            return -1;
        }
        return this.path.compareTo(rhs.path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChildData childData = (ChildData)o;
        return this.compareTo(childData) == 0;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String getPath() {
        return this.path;
    }

    public Stat getStat() {
        return this.stat;
    }

    public byte[] getData() {
        return this.data;
    }

    ChildData setStat(Stat stat) {
        return new ChildData(this.path, stat, this.data);
    }

    ChildData setData(byte[] data) {
        return new ChildData(this.path, this.stat, data);
    }
}

