/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.recipes.leader;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.curator.framework.CuratorFramework;
import com.netflix.curator.framework.recipes.leader.LeaderSelectorListener;
import com.netflix.curator.framework.recipes.leader.Participant;
import com.netflix.curator.framework.recipes.locks.InterProcessMutex;
import java.io.Closeable;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderSelector
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFramework client;
    private final LeaderSelectorListener listener;
    private final ExecutorService executorService;
    private final Executor executor;
    private final InterProcessMutex mutex;
    private volatile boolean hasLeadership;
    private volatile String id = "";
    private static final ThreadFactory defaultThreadFactory = new ThreadFactoryBuilder().setNameFormat("LeaderSelector-%d").build();

    public LeaderSelector(CuratorFramework client, String mutexPath, LeaderSelectorListener listener) {
        this(client, mutexPath, defaultThreadFactory, (Executor)MoreExecutors.sameThreadExecutor(), listener);
    }

    public LeaderSelector(CuratorFramework client, String mutexPath, ThreadFactory threadFactory, Executor executor, LeaderSelectorListener listener) {
        Preconditions.checkNotNull((Object)client);
        Preconditions.checkNotNull((Object)mutexPath);
        Preconditions.checkNotNull((Object)listener);
        this.client = client;
        this.listener = listener;
        this.executor = executor;
        this.hasLeadership = false;
        this.executorService = Executors.newFixedThreadPool(1, threadFactory);
        this.mutex = new InterProcessMutex(client, mutexPath){

            @Override
            protected byte[] getLockNodeBytes() {
                try {
                    return LeaderSelector.this.id.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new Error(e);
                }
            }
        };
    }

    public void setId(String id) {
        Preconditions.checkNotNull((Object)id);
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void start() {
        Preconditions.checkArgument((!this.executorService.isShutdown() ? 1 : 0) != 0);
        Preconditions.checkArgument((!this.hasLeadership ? 1 : 0) != 0);
        this.client.getConnectionStateListenable().addListener((Object)this.listener);
        this.executorService.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                LeaderSelector.this.doWork();
                return null;
            }
        });
    }

    @Override
    public void close() {
        Preconditions.checkArgument((!this.executorService.isShutdown() ? 1 : 0) != 0);
        this.client.getConnectionStateListenable().removeListener((Object)this.listener);
        this.executorService.shutdownNow();
    }

    public Collection<Participant> getParticipants() throws Exception {
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean isLeader = true;
        for (String path : this.mutex.getParticipantNodes()) {
            try {
                Participant participant = this.participantForPath(path, isLeader);
                builder.add((Object)participant);
            }
            catch (KeeperException.NoNodeException ignore) {
                // empty catch block
            }
            isLeader = false;
        }
        return builder.build();
    }

    public Participant getLeader() throws Exception {
        Collection<String> participantNodes = this.mutex.getParticipantNodes();
        if (participantNodes.size() > 0) {
            return this.participantForPath(participantNodes.iterator().next(), true);
        }
        return new Participant();
    }

    public boolean hasLeadership() {
        return this.hasLeadership;
    }

    private Participant participantForPath(String path, boolean markAsLeader) throws Exception {
        byte[] bytes = (byte[])this.client.getData().forPath(path);
        String thisId = new String(bytes, "UTF-8");
        return new Participant(thisId, markAsLeader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWork() throws Exception {
        this.hasLeadership = false;
        try {
            this.mutex.acquire();
            this.hasLeadership = true;
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        LeaderSelector.this.listener.takeLeadership(LeaderSelector.this.client);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception e) {
                        LeaderSelector.this.log.error("The leader threw an exception", (Throwable)e);
                    }
                }
            });
        }
        finally {
            this.hasLeadership = false;
            try {
                this.mutex.release();
            }
            catch (Exception exception) {}
        }
    }
}

