/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.recipes.locks;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.MoreExecutors;
import com.netflix.curator.framework.CuratorFramework;
import com.netflix.curator.framework.recipes.locks.InterProcessLock;
import com.netflix.curator.framework.recipes.locks.LockInternals;
import com.netflix.curator.framework.recipes.locks.LockInternalsDriver;
import com.netflix.curator.framework.recipes.locks.Revocable;
import com.netflix.curator.framework.recipes.locks.RevocationListener;
import com.netflix.curator.framework.recipes.locks.RevocationSpec;
import com.netflix.curator.framework.recipes.locks.StandardLockInternalsDriver;
import com.netflix.curator.utils.ZKPaths;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class InterProcessMutex
implements InterProcessLock,
Revocable<InterProcessMutex> {
    private final LockInternals internals;
    private final String basePath;
    private volatile LockData lockData;
    private static final String LOCK_NAME = "lock-";

    public InterProcessMutex(CuratorFramework client, String path) {
        this(client, path, LOCK_NAME, 1, new StandardLockInternalsDriver());
    }

    @Override
    public void acquire() throws Exception {
        if (!this.internalLock(-1L, null)) {
            throw new IOException("Lost connection while trying to acquire lock: " + this.basePath);
        }
    }

    @Override
    public boolean acquire(long time, TimeUnit unit) throws Exception {
        return this.internalLock(time, unit);
    }

    @Override
    public boolean isAcquiredInThisProcess() {
        return this.lockData != null;
    }

    @Override
    public void release() throws Exception {
        LockData localData = this.lockData;
        if (localData == null || localData.owningThread != Thread.currentThread()) {
            throw new IllegalMonitorStateException("You do not own the lock: " + this.basePath);
        }
        if (--localData.lockCount > 0) {
            return;
        }
        if (localData.lockCount < 0) {
            throw new IllegalMonitorStateException("Lock count has gone negative for lock: " + this.basePath);
        }
        this.internals.releaseLock(localData.lockPath);
        this.lockData = null;
    }

    public Collection<String> getParticipantNodes() throws Exception {
        List<String> names = this.internals.getSortedChildren();
        Iterable transformed = Iterables.transform(names, (Function)new Function<String, String>(){

            public String apply(String name) {
                return ZKPaths.makePath((String)InterProcessMutex.this.basePath, (String)name);
            }
        });
        return ImmutableList.copyOf((Iterable)transformed);
    }

    @Override
    public void makeRevocable(RevocationListener<InterProcessMutex> listener) {
        this.makeRevocable(listener, (Executor)MoreExecutors.sameThreadExecutor());
    }

    @Override
    public void makeRevocable(final RevocationListener<InterProcessMutex> listener, Executor executor) {
        this.internals.makeRevocable(new RevocationSpec(executor, new Runnable(){

            @Override
            public void run() {
                listener.revocationRequested(InterProcessMutex.this);
            }
        }));
    }

    InterProcessMutex(CuratorFramework client, String path, String lockName, int maxLeases, LockInternalsDriver driver) {
        this.basePath = path;
        this.internals = new LockInternals(client, driver, path, lockName, maxLeases);
    }

    boolean isOwnedByCurrentThread() {
        LockData localData = this.lockData;
        Thread owningThread = localData != null ? localData.owningThread : null;
        return Thread.currentThread() == owningThread;
    }

    protected byte[] getLockNodeBytes() {
        return null;
    }

    private boolean internalLock(long time, TimeUnit unit) throws Exception {
        boolean re_entering;
        LockData localData = this.lockData;
        boolean bl = re_entering = localData != null && localData.owningThread == Thread.currentThread();
        if (!re_entering && localData != null) {
            throw new IllegalMonitorStateException("This lock: " + this.basePath + " is already owned by " + localData.owningThread);
        }
        if (re_entering) {
            ++localData.lockCount;
            return true;
        }
        String lockPath = this.internals.attemptLock(time, unit, this.getLockNodeBytes());
        if (lockPath != null) {
            LockData localLockData = new LockData();
            localLockData.lockPath = lockPath;
            localLockData.lockCount = 1;
            localLockData.owningThread = Thread.currentThread();
            this.lockData = localLockData;
            return true;
        }
        return false;
    }

    private static class LockData {
        volatile Thread owningThread;
        volatile String lockPath;
        volatile int lockCount;

        private LockData() {
        }
    }
}

