/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.recipes.locks;

import com.google.common.collect.Lists;
import com.netflix.curator.CuratorZookeeperClient;
import com.netflix.curator.RetryLoop;
import com.netflix.curator.framework.CuratorFramework;
import com.netflix.curator.framework.api.BackgroundPathable;
import com.netflix.curator.framework.api.CuratorEvent;
import com.netflix.curator.framework.api.CuratorEventType;
import com.netflix.curator.framework.api.CuratorListener;
import com.netflix.curator.framework.recipes.locks.LockInternalsDriver;
import com.netflix.curator.framework.recipes.locks.PredicateResults;
import com.netflix.curator.framework.recipes.locks.RevocationSpec;
import com.netflix.curator.utils.EnsurePath;
import com.netflix.curator.utils.ZKPaths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.common.PathUtils;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LockInternals {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFramework client;
    private final String path;
    private final String basePath;
    private final CuratorListener listener;
    private final EnsurePath ensurePath;
    private final Watcher watcher;
    private final LockInternalsDriver driver;
    private final String lockName;
    private final AtomicReference<RevocationSpec> revocable = new AtomicReference<Object>(null);
    private final Watcher revocableWatcher = new Watcher(){

        public void process(WatchedEvent event) {
            if (event.getType() == Watcher.Event.EventType.NodeDataChanged) {
                try {
                    LockInternals.this.checkRevocableWatcher(event.getPath());
                }
                catch (Exception e) {
                    LockInternals.this.log.error("From RevocableWatcher check", (Throwable)e);
                }
            }
        }
    };
    private volatile int maxLeases;
    static final byte[] REVOKE_MESSAGE = "__REVOKE__".getBytes();

    public void clean() throws Exception {
        try {
            this.client.delete().forPath(this.basePath);
        }
        catch (KeeperException.BadVersionException ignore) {
        }
        catch (KeeperException.NotEmptyException notEmptyException) {
            // empty catch block
        }
    }

    LockInternals(CuratorFramework client, LockInternalsDriver driver, String path, String lockName, int maxLeases) {
        this.driver = driver;
        this.lockName = lockName;
        this.maxLeases = maxLeases;
        PathUtils.validatePath((String)path);
        this.client = client;
        this.basePath = path;
        this.path = ZKPaths.makePath((String)path, (String)lockName);
        this.ensurePath = client.newNamespaceAwareEnsurePath(this.basePath);
        this.watcher = new Watcher(){

            public void process(WatchedEvent watchedEvent) {
                LockInternals.this.notifyFromWatcher();
            }
        };
        this.listener = new CuratorListener(){

            public void eventReceived(CuratorFramework client, CuratorEvent event) throws Exception {
                if (event.getType() == CuratorEventType.WATCHED && event.getWatchedEvent().getState() != Watcher.Event.KeeperState.SyncConnected) {
                    LockInternals.this.notifyFromWatcher();
                }
            }
        };
    }

    synchronized void setMaxLeases(int maxLeases) {
        this.maxLeases = maxLeases;
        this.notifyAll();
    }

    void makeRevocable(RevocationSpec entry) {
        this.revocable.set(entry);
    }

    void releaseLock(String lockPath) throws Exception {
        this.revocable.set(null);
        this.client.getCuratorListenable().removeListener((Object)this.listener);
        this.client.delete().forPath(lockPath);
    }

    List<String> getSortedChildren() throws Exception {
        List children = (List)this.client.getChildren().forPath(this.basePath);
        ArrayList sortedList = Lists.newArrayList((Iterable)children);
        Collections.sort(sortedList, new Comparator<String>(){

            @Override
            public int compare(String lhs, String rhs) {
                return LockInternals.this.driver.fixForSorting(lhs, LockInternals.this.lockName).compareTo(LockInternals.this.driver.fixForSorting(rhs, LockInternals.this.lockName));
            }
        });
        return sortedList;
    }

    String attemptLock(long time, TimeUnit unit, byte[] lockNodeBytes) throws Exception {
        final long startMillis = System.currentTimeMillis();
        final Long millisToWait = unit != null ? Long.valueOf(unit.toMillis(time)) : null;
        final byte[] localLockNodeBytes = this.revocable.get() != null ? new byte[]{} : lockNodeBytes;
        PathAndFlag pathAndFlag = (PathAndFlag)RetryLoop.callWithRetry((CuratorZookeeperClient)this.client.getZookeeperClient(), (Callable)new Callable<PathAndFlag>(){

            @Override
            public PathAndFlag call() throws Exception {
                LockInternals.this.ensurePath.ensure(LockInternals.this.client.getZookeeperClient());
                String ourPath = localLockNodeBytes != null ? (String)LockInternals.this.client.create().withProtectedEphemeralSequential().forPath(LockInternals.this.path, localLockNodeBytes) : (String)LockInternals.this.client.create().withProtectedEphemeralSequential().forPath(LockInternals.this.path);
                boolean hasTheLock = LockInternals.this.internalLockLoop(startMillis, millisToWait, ourPath);
                return new PathAndFlag(hasTheLock, ourPath);
            }
        });
        if (pathAndFlag.hasTheLock) {
            this.client.getCuratorListenable().addListener((Object)this.listener);
            return pathAndFlag.path;
        }
        return null;
    }

    private void checkRevocableWatcher(String path) throws Exception {
        RevocationSpec entry = this.revocable.get();
        if (entry != null) {
            try {
                byte[] bytes = (byte[])((BackgroundPathable)this.client.getData().usingWatcher(this.revocableWatcher)).forPath(path);
                if (Arrays.equals(bytes, REVOKE_MESSAGE)) {
                    entry.getExecutor().execute(entry.getRunnable());
                }
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean internalLockLoop(long startMillis, Long millisToWait, String ourPath) throws Exception {
        if (this.revocable.get() != null) {
            ((BackgroundPathable)this.client.getData().usingWatcher(this.revocableWatcher)).forPath(ourPath);
        }
        boolean haveTheLock = false;
        boolean doDelete = false;
        try {
            while (this.client.isStarted()) {
                String sequenceNodeName;
                if (haveTheLock) return haveTheLock;
                List<String> children = this.getSortedChildren();
                PredicateResults predicateResults = this.driver.getsTheLock(this.client, children, sequenceNodeName = ourPath.substring(this.basePath.length() + 1), this.maxLeases);
                if (predicateResults.getsTheLock()) {
                    haveTheLock = true;
                    continue;
                }
                String previousSequencePath = this.basePath + "/" + predicateResults.getPathToWatch();
                LockInternals lockInternals = this;
                synchronized (lockInternals) {
                    Stat stat = (Stat)((BackgroundPathable)this.client.checkExists().usingWatcher(this.watcher)).forPath(previousSequencePath);
                    if (stat != null) {
                        if (millisToWait != null) {
                            millisToWait = millisToWait - (System.currentTimeMillis() - startMillis);
                            startMillis = System.currentTimeMillis();
                            if (millisToWait <= 0L) {
                                doDelete = true;
                                return haveTheLock;
                            }
                            this.wait(millisToWait);
                        } else {
                            this.wait();
                        }
                    }
                }
            }
            return haveTheLock;
        }
        catch (KeeperException e) {
            throw e;
        }
        catch (Exception e) {
            doDelete = true;
            throw e;
        }
        finally {
            if (doDelete) {
                this.client.delete().forPath(ourPath);
            }
        }
    }

    private synchronized void notifyFromWatcher() {
        this.notifyAll();
    }

    private static class PathAndFlag {
        final boolean hasTheLock;
        final String path;

        private PathAndFlag(boolean hasTheLock, String path) {
            this.hasTheLock = hasTheLock;
            this.path = path;
        }
    }
}

